/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class MetadataPortableResolverTest {
    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveFields(boolean key, String prefix) {
        Stream resolvedFields = MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(MetadataPortableResolverTest.field("field", QueryDataType.INT, prefix + ".field")), (Map)ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)"1", (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)"2", (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"3"), new DefaultSerializationServiceBuilder().build());
        Assertions.assertThat((Stream)resolvedFields).containsExactly((Object[])new MappingField[]{MetadataPortableResolverTest.field("field", QueryDataType.INT, prefix + ".field")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveFieldsFromClassDefinition(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addStringField("string").addCharField("character").addBooleanField("boolean").addByteField("byte").addShortField("short").addIntField("int").addLongField("long").addFloatField("float").addDoubleField("double").addDecimalField("decimal").addTimeField("time").addDateField("date").addTimestampField("timestamp").addTimestampWithTimezoneField("timestampTz").addPortableField("object", new ClassDefinitionBuilder(4, 5, 6).build()).build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        Stream resolvedFields = MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Collections.emptyList(), (Map)options, ss);
        Assertions.assertThat((Stream)resolvedFields).containsExactly((Object[])new MappingField[]{MetadataPortableResolverTest.field("string", QueryDataType.VARCHAR, prefix + ".string"), MetadataPortableResolverTest.field("character", QueryDataType.VARCHAR_CHARACTER, prefix + ".character"), MetadataPortableResolverTest.field("boolean", QueryDataType.BOOLEAN, prefix + ".boolean"), MetadataPortableResolverTest.field("byte", QueryDataType.TINYINT, prefix + ".byte"), MetadataPortableResolverTest.field("short", QueryDataType.SMALLINT, prefix + ".short"), MetadataPortableResolverTest.field("int", QueryDataType.INT, prefix + ".int"), MetadataPortableResolverTest.field("long", QueryDataType.BIGINT, prefix + ".long"), MetadataPortableResolverTest.field("float", QueryDataType.REAL, prefix + ".float"), MetadataPortableResolverTest.field("double", QueryDataType.DOUBLE, prefix + ".double"), MetadataPortableResolverTest.field("decimal", QueryDataType.DECIMAL, prefix + ".decimal"), MetadataPortableResolverTest.field("time", QueryDataType.TIME, prefix + ".time"), MetadataPortableResolverTest.field("date", QueryDataType.DATE, prefix + ".date"), MetadataPortableResolverTest.field("timestamp", QueryDataType.TIMESTAMP, prefix + ".timestamp"), MetadataPortableResolverTest.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, prefix + ".timestampTz"), MetadataPortableResolverTest.field("object", QueryDataType.OBJECT, prefix + ".object")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveFieldsWithoutClassDefinition(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)"1", (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)"2", (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"3");
        List<MappingField> fields = Arrays.asList(MetadataPortableResolverTest.field("string", QueryDataType.VARCHAR, prefix + ".string"), MetadataPortableResolverTest.field("character", QueryDataType.VARCHAR_CHARACTER, prefix + ".character"), MetadataPortableResolverTest.field("boolean", QueryDataType.BOOLEAN, prefix + ".boolean"), MetadataPortableResolverTest.field("byte", QueryDataType.TINYINT, prefix + ".byte"), MetadataPortableResolverTest.field("short", QueryDataType.SMALLINT, prefix + ".short"), MetadataPortableResolverTest.field("int", QueryDataType.INT, prefix + ".int"), MetadataPortableResolverTest.field("long", QueryDataType.BIGINT, prefix + ".long"), MetadataPortableResolverTest.field("float", QueryDataType.REAL, prefix + ".float"), MetadataPortableResolverTest.field("double", QueryDataType.DOUBLE, prefix + ".double"), MetadataPortableResolverTest.field("decimal", QueryDataType.DECIMAL, prefix + ".decimal"), MetadataPortableResolverTest.field("time", QueryDataType.TIME, prefix + ".time"), MetadataPortableResolverTest.field("date", QueryDataType.DATE, prefix + ".date"), MetadataPortableResolverTest.field("timestamp", QueryDataType.TIMESTAMP, prefix + ".timestamp"), MetadataPortableResolverTest.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, prefix + ".timestampTz"));
        Stream resolvedFields = MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, fields, (Map)options, ss);
        Assertions.assertThat((Stream)resolvedFields).containsExactlyElementsOf(fields);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_fieldIsObjectAndClassDefinitionDoesNotExist_then_throws(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)"1", (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)"2", (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"3");
        List<MappingField> fields = Collections.singletonList(MetadataPortableResolverTest.field("object", QueryDataType.OBJECT, prefix + ".object"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataPortableResolverTest.lambda$when_fieldIsObjectAndClassDefinitionDoesNotExist_then_throws$0(key, fields, (Map)options, ss)).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot derive Portable type for '" + String.valueOf(QueryDataTypeFamily.OBJECT) + "'");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresField_then_itsNameHasPrecedenceOverClassDefinitionOne(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("field").build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        Stream resolvedFields = MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(MetadataPortableResolverTest.field("renamed_field", QueryDataType.INT, prefix + ".field")), (Map)options, ss);
        Assertions.assertThat((Stream)resolvedFields).containsExactly((Object[])new MappingField[]{MetadataPortableResolverTest.field("renamed_field", QueryDataType.INT, prefix + ".field")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_userDeclaresFields_then_fieldsNotAddedFromClassDefinition(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("field1").addStringField("field2").build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        Stream resolvedFields = MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(MetadataPortableResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field2")), (Map)options, ss);
        Assertions.assertThat((Stream)resolvedFields).containsExactly((Object[])new MappingField[]{MetadataPortableResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field2")});
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_typeMismatchBetweenDeclaredAndClassDefinitionField_then_throws(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("field").build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataPortableResolverTest.lambda$when_typeMismatchBetweenDeclaredAndClassDefinitionField_then_throws$1(key, prefix, (Map)options, ss)).isInstanceOf(QueryException.class)).hasMessageContaining("Mismatch between declared and resolved type: field");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_objectUsedForCurrentlyUnknownType_then_allowed(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition nestedClassDef = new ClassDefinitionBuilder(1, 3, 4).addIntField("intField").build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntArrayField("intArrayField").addPortableField("nestedPortableField", nestedClassDef).build();
        ss.getPortableContext().registerClassDefinition(nestedClassDef);
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Arrays.asList(MetadataPortableResolverTest.field("intArrayField", QueryDataType.OBJECT, prefix + ".intArrayField"), MetadataPortableResolverTest.field("nestedPortableField", QueryDataType.OBJECT, prefix + ".nestedPortableField")), (Map)options, ss);
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void when_duplicateExternalName_then_throws(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("field").build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MetadataPortableResolverTest.lambda$when_duplicateExternalName_then_throws$2(key, prefix, (Map)options, ss)).isInstanceOf(QueryException.class)).hasMessageMatching("Duplicate external name: (__key|this).field");
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveMetadata(boolean key, String prefix) {
        KvMetadata metadata = MetadataPortableResolver.INSTANCE.resolveMetadata(key, Arrays.asList(MetadataPortableResolverTest.field("boolean", QueryDataType.BOOLEAN, prefix + ".boolean"), MetadataPortableResolverTest.field("byte", QueryDataType.TINYINT, prefix + ".byte"), MetadataPortableResolverTest.field("short", QueryDataType.SMALLINT, prefix + ".short"), MetadataPortableResolverTest.field("int", QueryDataType.INT, prefix + ".int"), MetadataPortableResolverTest.field("long", QueryDataType.BIGINT, prefix + ".long"), MetadataPortableResolverTest.field("float", QueryDataType.REAL, prefix + ".float"), MetadataPortableResolverTest.field("double", QueryDataType.DOUBLE, prefix + ".double"), MetadataPortableResolverTest.field("decimal", QueryDataType.DECIMAL, prefix + ".decimal"), MetadataPortableResolverTest.field("string", QueryDataType.VARCHAR, prefix + ".string"), MetadataPortableResolverTest.field("time", QueryDataType.TIME, prefix + ".time"), MetadataPortableResolverTest.field("date", QueryDataType.DATE, prefix + ".date"), MetadataPortableResolverTest.field("timestamp", QueryDataType.TIMESTAMP, prefix + ".timestamp"), MetadataPortableResolverTest.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, prefix + ".timestampTz")), (Map)ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)"1", (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)"2", (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"3"), new DefaultSerializationServiceBuilder().build());
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("boolean", QueryDataType.BOOLEAN, false, QueryPath.create((String)(prefix + ".boolean"))), new MapTableField("byte", QueryDataType.TINYINT, false, QueryPath.create((String)(prefix + ".byte"))), new MapTableField("short", QueryDataType.SMALLINT, false, QueryPath.create((String)(prefix + ".short"))), new MapTableField("int", QueryDataType.INT, false, QueryPath.create((String)(prefix + ".int"))), new MapTableField("long", QueryDataType.BIGINT, false, QueryPath.create((String)(prefix + ".long"))), new MapTableField("float", QueryDataType.REAL, false, QueryPath.create((String)(prefix + ".float"))), new MapTableField("double", QueryDataType.DOUBLE, false, QueryPath.create((String)(prefix + ".double"))), new MapTableField("decimal", QueryDataType.DECIMAL, false, QueryPath.create((String)(prefix + ".decimal"))), new MapTableField("string", QueryDataType.VARCHAR, false, QueryPath.create((String)(prefix + ".string"))), new MapTableField("time", QueryDataType.TIME, false, QueryPath.create((String)(prefix + ".time"))), new MapTableField("date", QueryDataType.DATE, false, QueryPath.create((String)(prefix + ".date"))), new MapTableField("timestamp", QueryDataType.TIMESTAMP, false, QueryPath.create((String)(prefix + ".timestamp"))), new MapTableField("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, false, QueryPath.create((String)(prefix + ".timestampTz"))), new MapTableField(prefix, QueryDataType.OBJECT, true, QueryPath.create((String)prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)GenericQueryTargetDescriptor.DEFAULT);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualToComparingFieldByField((Object)new PortableUpsertTargetDescriptor(new ClassDefinitionBuilder(1, 2, 3).addBooleanField("boolean").addByteField("byte").addShortField("short").addIntField("int").addLongField("long").addFloatField("float").addDoubleField("double").addDecimalField("decimal").addStringField("string").addTimeField("time").addDateField("date").addTimestampField("timestamp").addTimestampWithTimezoneField("timestampTz").build()));
    }

    @Test
    @Parameters(value={"true, __key", "false, this"})
    public void test_resolveMetadataWithExistingClassDefinition(boolean key, String prefix) {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("field").build();
        ss.getPortableContext().registerClassDefinition(classDefinition);
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(classDefinition.getFactoryId()), (Object)(key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(classDefinition.getClassId()), (Object)(key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(classDefinition.getVersion()));
        KvMetadata metadata = MetadataPortableResolver.INSTANCE.resolveMetadata(key, Collections.singletonList(MetadataPortableResolverTest.field("field", QueryDataType.INT, prefix + ".field")), (Map)options, ss);
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("field", QueryDataType.INT, false, QueryPath.create((String)(prefix + ".field"))), new MapTableField(prefix, QueryDataType.OBJECT, true, QueryPath.create((String)prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)GenericQueryTargetDescriptor.DEFAULT);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualToComparingFieldByField((Object)new PortableUpsertTargetDescriptor(classDefinition));
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }

    private static /* synthetic */ void lambda$when_duplicateExternalName_then_throws$2(boolean key, String prefix, Map options, InternalSerializationService ss) throws Throwable {
        MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Arrays.asList(MetadataPortableResolverTest.field("field1", QueryDataType.INT, prefix + ".field"), MetadataPortableResolverTest.field("field2", QueryDataType.VARCHAR, prefix + ".field")), options, ss);
    }

    private static /* synthetic */ void lambda$when_typeMismatchBetweenDeclaredAndClassDefinitionField_then_throws$1(boolean key, String prefix, Map options, InternalSerializationService ss) throws Throwable {
        MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, Collections.singletonList(MetadataPortableResolverTest.field("field", QueryDataType.VARCHAR, prefix + ".field")), options, ss);
    }

    private static /* synthetic */ void lambda$when_fieldIsObjectAndClassDefinitionDoesNotExist_then_throws$0(boolean key, List fields, Map options, InternalSerializationService ss) throws Throwable {
        MetadataPortableResolver.INSTANCE.resolveAndValidateFields(key, fields, options, ss).collect(Collectors.toList());
    }
}

