/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.JoinByPrimitiveKeyProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.JoinScanProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.Joiner;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.extract.QueryPath;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnitParamsRunner.class)
public class JoinerTest {
    @Mock
    private DAG dag;
    @Mock
    private Vertex vertex;
    @Mock
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private AutoCloseable openMocks;

    @Before
    public void setUp() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    private Object[] joinTypes() {
        return new Object[]{JoinRelType.INNER, JoinRelType.LEFT};
    }

    @Test
    @Parameters(method="joinTypes")
    public void test_joinByPrimitiveKey(JoinRelType joinType) {
        BDDMockito.given((Object)this.rightRowProjectorSupplier.paths()).willReturn((Object)new QueryPath[]{QueryPath.KEY_PATH});
        BDDMockito.given((Object)this.dag.newUniqueVertex(ArgumentMatchers.contains((String)"Lookup"), (ProcessorSupplier)ArgumentMatchers.isA(JoinByPrimitiveKeyProcessorSupplier.class))).willReturn((Object)this.vertex);
        SqlConnector.VertexWithInputConfig vertexWithConfig = Joiner.join((DAG)this.dag, (String)"imap-name", (String)"table-name", (JetJoinInfo)JoinerTest.joinInfo(joinType, new int[]{0}, new int[]{0}), (KvRowProjector.Supplier)this.rightRowProjectorSupplier);
        Assertions.assertThat((Object)vertexWithConfig.vertex()).isEqualTo((Object)this.vertex);
        Assertions.assertThat((Object)vertexWithConfig.configureEdgeFn()).isNotNull();
    }

    @Test
    @Parameters(method="joinTypes")
    public void test_joinByPredicate(JoinRelType joinType) {
        BDDMockito.given((Object)this.rightRowProjectorSupplier.paths()).willReturn((Object)new QueryPath[]{QueryPath.create((String)"path")});
        BDDMockito.given((Object)this.dag.newUniqueVertex(ArgumentMatchers.contains((String)"Predicate"), (ProcessorMetaSupplier)ArgumentMatchers.isA(ProcessorMetaSupplier.class))).willReturn((Object)this.vertex);
        SqlConnector.VertexWithInputConfig vertexWithConfig = Joiner.join((DAG)this.dag, (String)"imap-name", (String)"table-name", (JetJoinInfo)JoinerTest.joinInfo(joinType, new int[]{0}, new int[]{0}), (KvRowProjector.Supplier)this.rightRowProjectorSupplier);
        Assertions.assertThat((Object)vertexWithConfig.vertex()).isEqualTo((Object)this.vertex);
        Assertions.assertThat((Object)vertexWithConfig.configureEdgeFn()).isNotNull();
    }

    @Test
    @Parameters(method="joinTypes")
    public void test_joinByScan(JoinRelType joinType) {
        BDDMockito.given((Object)this.rightRowProjectorSupplier.paths()).willReturn((Object)new QueryPath[]{QueryPath.VALUE_PATH});
        BDDMockito.given((Object)this.dag.newUniqueVertex(ArgumentMatchers.contains((String)"Scan"), (ProcessorSupplier)ArgumentMatchers.isA(JoinScanProcessorSupplier.class))).willReturn((Object)this.vertex);
        SqlConnector.VertexWithInputConfig vertexWithConfig = Joiner.join((DAG)this.dag, (String)"imap-name", (String)"table-name", (JetJoinInfo)JoinerTest.joinInfo(joinType, new int[0], new int[0]), (KvRowProjector.Supplier)this.rightRowProjectorSupplier);
        Assertions.assertThat((Object)vertexWithConfig.vertex()).isEqualTo((Object)this.vertex);
        Assertions.assertThat((Object)vertexWithConfig.configureEdgeFn()).isNull();
    }

    private static JetJoinInfo joinInfo(JoinRelType joinType, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices) {
        return new JetJoinInfo(joinType, leftEquiJoinIndices, rightEquiJoinIndices, null, null);
    }
}

