/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.JoinScanProcessorSupplier;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinScanProcessorTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final Expression<Boolean> TRUE_PREDICATE = ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN);
    private static final List<Expression<?>> PROJECTIONS = Arrays.asList(ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), ColumnExpression.create((int)1, (QueryDataType)QueryDataType.VARCHAR));
    private static final Expression<Boolean> FALSE_PREDICATE = ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN);
    private static final Expression<Boolean> EQUALS_PREDICATE = ComparisonPredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.EQUALS);
    private IMap<Object, Object> map;

    @BeforeClass
    public static void beforeClass() {
        JoinScanProcessorTest.initialize((int)2, null);
    }

    @Before
    public void before() {
        this.map = JoinScanProcessorTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void test_innerJoin() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, PROJECTIONS, TRUE_PREDICATE, Collections.singletonList(JoinScanProcessorTest.jetRow(1)), Collections.singletonList(JoinScanProcessorTest.jetRow(1, 1, "value")));
    }

    @Test
    public void when_innerJoinFilteredOutByProjector_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, FALSE_PREDICATE, PROJECTIONS, TRUE_PREDICATE, Collections.singletonList(JoinScanProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void when_innerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, Collections.singletonList(ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR)), TRUE_PREDICATE, Collections.singletonList(JoinScanProcessorTest.jetRow(1)), Collections.singletonList(JoinScanProcessorTest.jetRow(1, "modified")));
    }

    @Test
    public void when_innerJoinFilteredOutByCondition_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, PROJECTIONS, FALSE_PREDICATE, Collections.singletonList(JoinScanProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void test_outerJoin() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, PROJECTIONS, EQUALS_PREDICATE, Arrays.asList(JoinScanProcessorTest.jetRow(1), JoinScanProcessorTest.jetRow(2)), Arrays.asList(JoinScanProcessorTest.jetRow(1, 1, "value"), JoinScanProcessorTest.jetRow(2, null, null)));
    }

    @Test
    public void when_outerJoinFilteredOutByProjector_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, FALSE_PREDICATE, PROJECTIONS, TRUE_PREDICATE, Arrays.asList(JoinScanProcessorTest.jetRow(1), JoinScanProcessorTest.jetRow(2)), Arrays.asList(JoinScanProcessorTest.jetRow(1, null, null), JoinScanProcessorTest.jetRow(2, null, null)));
    }

    @Test
    public void when_outerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, Arrays.asList(ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR)), EQUALS_PREDICATE, Arrays.asList(JoinScanProcessorTest.jetRow(1), JoinScanProcessorTest.jetRow(2)), Arrays.asList(JoinScanProcessorTest.jetRow(1, 1, "modified"), JoinScanProcessorTest.jetRow(2, null, null)));
    }

    @Test
    public void when_outerJoinFilteredOutByCondition_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, PROJECTIONS, FALSE_PREDICATE, Arrays.asList(JoinScanProcessorTest.jetRow(1), JoinScanProcessorTest.jetRow(2)), Arrays.asList(JoinScanProcessorTest.jetRow(1, null, null), JoinScanProcessorTest.jetRow(2, null, null)));
    }

    private void runTest(JoinRelType joinType, Expression<Boolean> rowProjectorCondition, List<Expression<?>> rowProjectorProjections, Expression<Boolean> condition, List<JetSqlRow> input, List<JetSqlRow> output) {
        KvRowProjector.Supplier projectorSupplier = KvRowProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.VARCHAR}, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, rowProjectorCondition, rowProjectorProjections);
        JoinScanProcessorSupplier processor = new JoinScanProcessorSupplier(new JetJoinInfo(joinType, new int[]{0}, new int[]{0}, null, condition), MAP_NAME, projectorSupplier);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)processor)).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).input(input).hazelcastInstance(JoinScanProcessorTest.instance()).outputChecker(SqlTestSupport::compareRowLists).disableProgressAssertion().expectOutput(output);
    }
}

