/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.connector.map.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.query.impl.predicates.PredicateTestUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InsertProcessorTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private Map<Object, Object> map;

    @BeforeClass
    public static void beforeClass() {
        InsertProcessorTest.initialize((int)1, null);
    }

    @Before
    public void before() {
        this.map = InsertProcessorTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void test_insert() {
        this.executeInsert(Collections.singletonList(InsertProcessorTest.jetRow(1, 1)), Collections.singletonList(InsertProcessorTest.jetRow(1L)));
        Assertions.assertThat(this.map).containsExactly(new Map.Entry[]{PredicateTestUtils.entry((Object)1, (Object)1)});
    }

    @Test
    public void test_multiInsert() {
        this.executeInsert(Arrays.asList(InsertProcessorTest.jetRow(1, 1), InsertProcessorTest.jetRow(2, 2)), Collections.singletonList(InsertProcessorTest.jetRow(2L)));
        Assertions.assertThat(this.map).containsExactlyInAnyOrderEntriesOf(Map.of(1, 1, 2, 2));
    }

    @Test
    public void test_noInput() {
        this.executeInsert(Collections.emptyList(), Collections.singletonList(InsertProcessorTest.jetRow(0L)));
        Assertions.assertThat(this.map).isEmpty();
    }

    @Test
    public void when_keyIsNull_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeInsert(Collections.singletonList(InsertProcessorTest.jetRow(null, 1)), Collections.emptyList())).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot write NULL to '__key' field");
    }

    @Test
    public void when_ValueIsNull_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeInsert(Collections.singletonList(InsertProcessorTest.jetRow(1, null)), Collections.emptyList())).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot write NULL to 'this' field");
    }

    @Test
    public void when_keyAlreadyExists_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeInsert(() -> this.map.put(1, 1), Collections.singletonList(InsertProcessorTest.jetRow(1, 2)), Collections.emptyList())).isInstanceOf(QueryException.class)).hasMessageContaining("Duplicate key");
    }

    @Test
    public void when_attemptsToInsertDuplicateKey_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeInsert(Arrays.asList(InsertProcessorTest.jetRow(1, 1), InsertProcessorTest.jetRow(1, 2)), Collections.emptyList())).isInstanceOf(QueryException.class)).hasMessageContaining("Duplicate key");
    }

    @Test
    public void when_maxAccumulatedKeysCountIsExceeded_then_fail() {
        Assertions.assertThatThrownBy(() -> this.executeInsert(1L, Arrays.asList(InsertProcessorTest.jetRow(1, 1), InsertProcessorTest.jetRow(2, 2)), Collections.emptyList())).isInstanceOf(AccumulationLimitExceededException.class);
    }

    private void executeInsert(List<JetSqlRow> rows, List<JetSqlRow> expectedOutput) {
        this.executeInsert(() -> this.map.clear(), Long.MAX_VALUE, rows, expectedOutput);
    }

    private void executeInsert(long maxAccumulatedKeys, List<JetSqlRow> rows, List<JetSqlRow> expectedOutput) {
        this.executeInsert(() -> this.map.clear(), maxAccumulatedKeys, rows, expectedOutput);
    }

    private void executeInsert(Runnable setup, List<JetSqlRow> rows, List<JetSqlRow> expectedOutput) {
        this.executeInsert(setup, Long.MAX_VALUE, rows, expectedOutput);
    }

    private void executeInsert(Runnable setup, long maxAccumulatedKeys, List<JetSqlRow> rows, List<JetSqlRow> expectedOutput) {
        KvProjector.Supplier projectorSupplier = KvProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (UpsertTargetDescriptor)PrimitiveUpsertTargetDescriptor.INSTANCE, (UpsertTargetDescriptor)PrimitiveUpsertTargetDescriptor.INSTANCE, (boolean)true);
        InsertProcessorSupplier processor = new InsertProcessorSupplier(MAP_NAME, projectorSupplier);
        JobConfig config = new JobConfig().setArgument("__sql.arguments", Collections.emptyList()).setMaxProcessorAccumulatedRecords(maxAccumulatedKeys);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)processor)).hazelcastInstance(InsertProcessorTest.instance()).jobConfig(config).disableSnapshots().disableProgressAssertion().executeBeforeEachRun(setup).input(rows).outputChecker(SqlTestSupport::compareRowLists).expectOutput(expectedOutput);
    }
}

