/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlConnector;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelJVMTest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NightlyTest.class, ParallelJVMTest.class})
public class SqlPlanCacheTest
extends KafkaSqlTestSupport {
    private static final int INITIAL_PARTITION_COUNT = 4;

    private static void createMapping(String tableName, String topicName, String valueFormat, String offset) {
        ((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(tableName, KafkaSqlConnector.class).externalName(topicName).options(new Object[]{"valueFormat", valueFormat, "bootstrap.servers", kafkaTestSupport.getBrokerConnectionString(), "auto.offset.reset", offset})).createOrReplace();
    }

    @Test
    public void test_tableName() {
        String topicName = SqlPlanCacheTest.createRandomTopic();
        SqlPlanCacheTest.createMapping("kafka1", topicName, "int", "earliest");
        sqlService.execute("SELECT * FROM kafka1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("kafka2", topicName, "int", "earliest");
        sqlService.execute("DROP MAPPING kafka1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_topicName() {
        SqlPlanCacheTest.createMapping("kafka", SqlPlanCacheTest.createRandomTopic(), "int", "earliest");
        sqlService.execute("SELECT * FROM kafka", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("kafka", SqlPlanCacheTest.createRandomTopic(), "int", "earliest");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_fieldList() {
        String topicName = SqlPlanCacheTest.createRandomTopic();
        SqlPlanCacheTest.createMapping("kafka", topicName, "int", "earliest");
        sqlService.execute("SELECT * FROM kafka", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("kafka", topicName, "varchar", "earliest");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_options() {
        String topicName = SqlPlanCacheTest.createRandomTopic();
        SqlPlanCacheTest.createMapping("kafka", topicName, "int", "earliest");
        sqlService.execute("SELECT * FROM kafka", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMapping("kafka", topicName, "int", "latest");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_dmlCaching() {
        String topicName = SqlPlanCacheTest.createRandomTopic();
        SqlPlanCacheTest.createMapping("kafka", topicName, "int", "earliest");
        sqlService.execute("INSERT INTO kafka VALUES(0)", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        sqlService.execute("SINK INTO kafka VALUES(0)", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(2);
        sqlService.execute("DROP MAPPING kafka", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    private static String createRandomTopic() {
        return SqlPlanCacheTest.createRandomTopic(4);
    }
}

