/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.oracle;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.oracle.OracleUpsertQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.OracleSqlDialect;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class OracleUpsertQueryBuilderTest {
    @Mock
    JdbcTable jdbcTable;
    SqlDialect dialect = OracleSqlDialect.DEFAULT;

    @Before
    public void setUp() {
        this.jdbcTable = (JdbcTable)Mockito.mock(JdbcTable.class);
        Mockito.when((Object)this.jdbcTable.getExternalName()).thenReturn((Object)new String[]{"table1"});
        Mockito.when((Object)this.jdbcTable.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.jdbcTable.dbFieldNames()).thenReturn(Arrays.asList("field1", "field2"));
        Mockito.when((Object)this.jdbcTable.getPrimaryKeyList()).thenReturn(Arrays.asList("pk1", "pk2"));
    }

    @Test
    public void appendMergeClause() {
        OracleUpsertQueryBuilder builder = new OracleUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendMergeClause(sb);
        String mergeClause = sb.toString();
        Assertions.assertThat((String)mergeClause).isEqualTo("MERGE INTO \"table1\" TARGET USING (SELECT ? as \"field1\", ? as \"field2\" FROM dual) SOURCE ON (TARGET.\"pk1\" = SOURCE.\"pk1\" AND TARGET.\"pk2\" = SOURCE.\"pk2\")");
    }

    @Test
    public void appendMatchedClause() {
        OracleUpsertQueryBuilder builder = new OracleUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendMatchedClause(sb);
        String matchedClause = sb.toString();
        Assertions.assertThat((String)matchedClause).isEqualTo("WHEN MATCHED THEN UPDATE SET TARGET.\"field1\" = SOURCE.\"field1\", TARGET.\"field2\" = SOURCE.\"field2\" WHEN NOT MATCHED THEN INSERT (\"field1\", \"field2\") VALUES(SOURCE.\"field1\", SOURCE.\"field2\")");
    }

    @Test
    public void query() {
        OracleUpsertQueryBuilder builder = new OracleUpsertQueryBuilder(this.jdbcTable, this.dialect);
        String result = builder.query();
        Assertions.assertThat((String)result).isEqualTo("MERGE INTO \"table1\" TARGET USING (SELECT ? as \"field1\", ? as \"field2\" FROM dual) SOURCE ON (TARGET.\"pk1\" = SOURCE.\"pk1\" AND TARGET.\"pk2\" = SOURCE.\"pk2\") WHEN MATCHED THEN UPDATE SET TARGET.\"field1\" = SOURCE.\"field1\", TARGET.\"field2\" = SOURCE.\"field2\" WHEN NOT MATCHED THEN INSERT (\"field1\", \"field2\") VALUES(SOURCE.\"field1\", SOURCE.\"field2\")");
    }

    @Test
    public void queryWhenPKPresentInDbFieldNames() {
        Mockito.when((Object)this.jdbcTable.getExternalName()).thenReturn((Object)new String[]{"table1"});
        Mockito.when((Object)this.jdbcTable.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.jdbcTable.dbFieldNames()).thenReturn(Arrays.asList("field1", "pk1"));
        Mockito.when((Object)this.jdbcTable.getPrimaryKeyList()).thenReturn(Arrays.asList("pk1"));
        OracleUpsertQueryBuilder builder = new OracleUpsertQueryBuilder(this.jdbcTable, this.dialect);
        String result = builder.query();
        Assertions.assertThat((String)result).isEqualTo("MERGE INTO \"table1\" TARGET USING (SELECT ? as \"field1\", ? as \"pk1\" FROM dual) SOURCE ON (TARGET.\"pk1\" = SOURCE.\"pk1\") WHEN MATCHED THEN UPDATE SET TARGET.\"field1\" = SOURCE.\"field1\" WHEN NOT MATCHED THEN INSERT (\"field1\", \"pk1\") VALUES(SOURCE.\"field1\", SOURCE.\"pk1\")");
    }
}

