/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mssql;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.mssql.MSSQLUpsertQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MssqlSqlDialect;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MSSQLUpsertQueryBuilderTest {
    @Mock
    JdbcTable jdbcTable;
    SqlDialect dialect = MssqlSqlDialect.DEFAULT;

    MSSQLUpsertQueryBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.jdbcTable.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.jdbcTable.dbFieldNames()).thenReturn(Arrays.asList("field1", "field2"));
        Mockito.when((Object)this.jdbcTable.getPrimaryKeyList()).thenReturn(Arrays.asList("pk1", "pk2"));
    }

    @Test
    void appendMergeClause() {
        MSSQLUpsertQueryBuilder builder = new MSSQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendMergeClause(sb);
        String mergeClause = sb.toString();
        Assertions.assertThat((String)mergeClause).isEqualTo("MERGE [table1] USING (VALUES (?, ?)) AS source ([field1], [field2]) ON [table1].[pk1] = source.[pk1] AND [table1].[pk2] = source.[pk2]");
    }

    @Test
    void appendValuesClause() {
        MSSQLUpsertQueryBuilder builder = new MSSQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendValuesClause(sb);
        String valuesClause = sb.toString();
        Assertions.assertThat((String)valuesClause).isEqualTo("VALUES (?, ?)");
    }

    @Test
    void appendMatchedClause() {
        MSSQLUpsertQueryBuilder builder = new MSSQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendMatchedClause(sb);
        String matchedClause = sb.toString();
        Assertions.assertThat((String)matchedClause).isEqualTo("WHEN MATCHED THEN UPDATE SET [field1] = source.[field1], [field2] = source.[field2] WHEN NOT MATCHED THEN INSERT ([field1], [field2]) VALUES(source.[field1], source.[field2]);");
    }

    @Test
    void query() {
        MSSQLUpsertQueryBuilder builder = new MSSQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        String result = builder.query();
        Assertions.assertThat((String)result).isEqualTo("MERGE [table1] USING (VALUES (?, ?)) AS source ([field1], [field2]) ON [table1].[pk1] = source.[pk1] AND [table1].[pk2] = source.[pk2] WHEN MATCHED THEN UPDATE SET [field1] = source.[field1], [field2] = source.[field2] WHEN NOT MATCHED THEN INSERT ([field1], [field2]) VALUES(source.[field1], source.[field2]);");
    }
}

