/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.h2;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.h2.H2UpsertQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.H2SqlDialect;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class H2UpsertQueryBuilderTest {
    @Mock
    JdbcTable table;
    SqlDialect dialect = H2SqlDialect.DEFAULT;

    H2UpsertQueryBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.table.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.table.getPrimaryKeyList()).thenReturn(Arrays.asList("pk1", "pk2"));
        Mockito.when((Object)this.table.dbFieldNames()).thenReturn(Arrays.asList("field1", "field2"));
    }

    @Test
    void appendMergeClause() {
        H2UpsertQueryBuilder builder = new H2UpsertQueryBuilder(this.table, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendMergeClause(sb);
        String mergeClause = sb.toString();
        Assertions.assertThat((String)mergeClause).isEqualTo("MERGE INTO \"table1\" (\"field1\",\"field2\")");
    }

    @Test
    void appendKeyClause() {
        H2UpsertQueryBuilder builder = new H2UpsertQueryBuilder(this.table, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendKeyClause(sb);
        String keyClause = sb.toString();
        Assertions.assertThat((String)keyClause).isEqualTo("KEY (\"pk1\",\"pk2\")");
    }

    @Test
    void appendValuesClause() {
        H2UpsertQueryBuilder builder = new H2UpsertQueryBuilder(this.table, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendValuesClause(sb);
        String valueClause = sb.toString();
        Assertions.assertThat((String)valueClause).isEqualTo("VALUES (?,?)");
    }

    @Test
    void testQuery() {
        H2UpsertQueryBuilder builder = new H2UpsertQueryBuilder(this.table, this.dialect);
        String query = builder.query();
        Assertions.assertThat((String)query).isEqualTo("MERGE INTO \"table1\" (\"field1\",\"field2\") KEY (\"pk1\",\"pk2\") VALUES (?,?)");
    }
}

