/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class UpdatePredicatePushDownJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private static final String JSON = "{\"value\":42}";
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        UpdatePredicatePushDownJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = UpdatePredicatePushDownJdbcSqlConnectorTest.randomTableName();
        UpdatePredicatePushDownJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(100)", "age INT", "data VARCHAR(100)");
        UpdatePredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdatePredicatePushDownJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 'name-0', 0, '{\"value\":42}')");
        UpdatePredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + UpdatePredicatePushDownJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 'name-1', 1, '{\"value\":42}')");
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR,  age INT,  data VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void noParameterNoPredicate() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated'", new Object[0]);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "updated", 1, JSON));
    }

    @Test
    public void noParameterPredicateCanPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE age = 0", new Object[0]);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void noParameterPartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE age = 0 AND JSON_QUERY(data, '$.value') = '42'", new Object[0]);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetClauseNoPredicate() {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ?", "updated");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "updated", 1, JSON));
    }

    @Test
    public void parameterInSetClausePredicateCanPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = 0", "updated");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetClausePartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = 0 AND JSON_QUERY(data, '$.value') = '42'", "updated");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePredicateCanPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE age = ?", 0);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = 'updated' WHERE age = ? AND JSON_QUERY(data, '$.value') = '42'", 0);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClausePredicateCanPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = ?", "updated", 0);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClausePredicateCanPushDownWithCastParameter() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = cast(? as integer)", "updated", "0");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClausePredicateCanPushDownWithCastColumn() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE cast(age as varchar) in (?, ?)", "updated", "not a number", "0");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClausePartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = ? AND JSON_QUERY(data, '$.value') = '42'", "updated", 0);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClauseBothPartsPartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE age = ? AND JSON_QUERY(data, '$.value') = ?", "updated", 0, "42");
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInSetAndWhereClauseBothPartsReversePartOfPredicateCanNotPushDown() throws Exception {
        UpdatePredicatePushDownJdbcSqlConnectorTest.execute("UPDATE " + this.tableName + " SET name = ? WHERE JSON_QUERY(data, '$.value') = ? AND age = ?", "updated", "42", 0);
        UpdatePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(0, "updated", 0, JSON), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }
}

