/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.SupportedDatabases;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MysqlSqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.SybaseSqlDialect;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class SupportedDatabasesTest {
    @Mock
    JdbcTable jdbcTable;
    @Mock
    SybaseSqlDialect sybaseSqlDialect;
    @Mock
    MysqlSqlDialect mysqlSqlDialect;
    private AutoCloseable openMocks;

    @Before
    public void setUp() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    public void testUpsertDialectNotSupported() {
        boolean result = SupportedDatabases.isDialectSupported((SqlDialect)this.sybaseSqlDialect);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testUpsertDialectSupported() {
        boolean result = SupportedDatabases.isDialectSupported((SqlDialect)this.mysqlSqlDialect);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testMySQL() {
        String dbName = "MYSQL";
        boolean newDB1 = SupportedDatabases.isNewDatabase((String)dbName);
        Assertions.assertThat((boolean)newDB1).isFalse();
    }

    @Test
    public void testPostgreSQL() {
        String dbName = "POSTGRESQL";
        boolean newDB = SupportedDatabases.isNewDatabase((String)dbName);
        Assertions.assertThat((boolean)newDB).isFalse();
    }

    @Test
    public void testH2() {
        String dbName = "H2";
        boolean newDB = SupportedDatabases.isNewDatabase((String)dbName);
        Assertions.assertThat((boolean)newDB).isFalse();
    }

    @Test
    public void test_notSupportedDB() {
        String dbName = "cassandra";
        boolean newDB = SupportedDatabases.isNewDatabase((String)dbName);
        Assertions.assertThat((boolean)newDB).isTrue();
    }
}

