/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SinkJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        SinkJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = SinkJdbcSqlConnectorTest.randomTableName();
    }

    @Test
    public void sinkIntoTable() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.createMapping(this.tableName);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void sinkIntoTableWithExternalName() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        String mappingName = "mapping_" + SinkJdbcSqlConnectorTest.randomName();
        SinkJdbcSqlConnectorTest.createMapping(this.tableName, mappingName);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + mappingName + " VALUES (0, 'name-0')", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void sinkIntoTableColumnHasExternalName() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void sinkIntoTableWithColumns() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.createMapping(this.tableName);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " (name, id) VALUES ('name-0', 0), ('name-1', 1)", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void sinkIntoTableWithColumnsColumnHasExternalName() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " (fullName, id) VALUES ('name-0', 0), ('name-1', 1)", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void sinkIntoTableMultipleValues() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.createMapping(this.tableName);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " SELECT v,'name-' || v FROM TABLE(generate_series(0,4))", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4"));
    }

    @Test
    public void sinkIntoTableReverseColumnOrder() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)");
        SinkJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " (name, id) VALUES ('name-0', 0)", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void updateTableWithColumns() throws Exception {
        SinkJdbcSqlConnectorTest.createTable(this.tableName);
        SinkJdbcSqlConnectorTest.createMapping(this.tableName);
        SinkJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"));
        SinkJdbcSqlConnectorTest.execute("SINK INTO " + this.tableName + " (name, id) VALUES ('name-2', 0), ('name-3', 1)", new Object[0]);
        SinkJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-2"), new SqlTestSupport.Row(1, "name-3"));
    }
}

