/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.config.Config;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.impl.DataConnectionTestUtil;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.JdbcObjectProvider;
import com.hazelcast.test.jdbc.MySQLDatabaseProvider;
import com.hazelcast.test.jdbc.PostgresDatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MappingJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private static final String LE = System.lineSeparator();
    protected String tableName;

    @BeforeClass
    public static void beforeClass() {
        MappingJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = MappingJdbcSqlConnectorTest.randomTableName();
    }

    @Test
    public void createMappingWithExternalTableName() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        String mappingName = "mapping_" + MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createMapping(this.tableName, mappingName);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(mappingName)}));
    }

    @Test
    public void createMappingWithExternalSchemaAndTableName() throws Exception {
        Assumptions.assumeThat((Object)recordProvider).isInstanceOf(JdbcObjectProvider.class);
        String schemaName = "schema1";
        MappingJdbcSqlConnectorTest.executeJdbc(((JdbcObjectProvider)recordProvider).createSchemaQuery(schemaName));
        MappingJdbcSqlConnectorTest.createTableNoQuote(MappingJdbcSqlConnectorTest.quote(schemaName, this.tableName));
        String mappingName = "mapping_" + MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createMapping("\"schema1\".\"" + this.tableName + "\"", mappingName);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(mappingName)}));
        String expectedMappingQuery = "CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"" + mappingName + "\" EXTERNAL NAME \"schema1\".\"" + this.tableName + "\" (" + LE + "  \"id\" INTEGER," + LE + "  \"name\" VARCHAR" + LE + ")" + LE + "DATA CONNECTION \"testDatabaseRef\"" + LE + "OBJECT TYPE \"Table\"";
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT GET_DDL('relation', '" + mappingName + "')", List.of(new SqlTestSupport.Row(expectedMappingQuery)));
    }

    @Test
    public void createMappingWithExternalTableNameTooManyComponents() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " EXTERNAL NAME \"aaaa\".\"bbbb\".\"cccc\".\"dddd\"  ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Invalid external name \"aaaa\".\"bbbb\".\"cccc\".\"dddd\"");
    }

    @Test
    public void createMappingWithExternalTableNameTooManyComponentsNoQuotes() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " EXTERNAL NAME aaaa.bbbb.cccc.dddd  ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Invalid external name \"aaaa\".\"bbbb\".\"cccc\".\"dddd\"");
    }

    @Test
    public void createMappingWithoutDataConnection() {
        this.tableName = MappingJdbcSqlConnectorTest.randomTableName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " EXTERNAL NAME " + this.tableName + " ( id INT,  name VARCHAR ) TYPE JDBC", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("You must provide data connection when using the Jdbc connector");
    }

    @Test
    public void createMappingTableDoesNotExist() {
        this.tableName = MappingJdbcSqlConnectorTest.randomTableName();
        Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Collections.emptyList());
    }

    @Test
    public void createMappingNoColumnsTableDoesNotExist() {
        this.tableName = MappingJdbcSqlConnectorTest.randomTableName();
        Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Collections.emptyList());
    }

    @Test
    public void createMappingWithExternalFieldName() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name ) DATA CONNECTION testDatabaseRef", new Object[0]);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(this.tableName)}));
        MappingJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT id,fullName FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0")}));
    }

    @Test
    public void createMappingFieldDoesNotExist() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Could not resolve field with name fullName");
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Collections.emptyList());
    }

    @Test
    public void createMappingExternalFieldDoesNotExist() throws Exception {
        this.tableName = MappingJdbcSqlConnectorTest.randomTableName();
        DataConnectionTestUtil.executeJdbc((String)dbConnectionUrl, (String)("CREATE TABLE " + MappingJdbcSqlConnectorTest.quote(this.tableName) + " (" + MappingJdbcSqlConnectorTest.quote("id") + " INT PRIMARY KEY, " + MappingJdbcSqlConnectorTest.quote("name") + " VARCHAR(10))"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.executeUpdate("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME myName ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Could not resolve field with external name myName");
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Collections.emptyList());
    }

    @Test
    public void createMappingFieldTypesDoNotMatch() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id BOOLEAN,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageMatching("Type BOOLEAN of field id does not match db type (INTEGER|DECIMAL)");
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SHOW MAPPINGS", Collections.emptyList());
    }

    @Test
    public void when_createMappingWithImplicitFieldTypesDefinition_then_orderIsPreserved() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName, "id VARCHAR(10) PRIMARY KEY", "name VARCHAR(100)");
        MappingJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + MappingJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('0', 'name-0')");
        MappingJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + MappingJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('1', 'name-1')");
        MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName, Arrays.asList(new SqlTestSupport.Row("0", "name-0"), new SqlTestSupport.Row("1", "name-1")));
    }

    @Test
    public void when_mappingIsDeclaredWithDataConnection_then_itIsAvailable() throws Exception {
        String dcName = MappingJdbcSqlConnectorTest.randomName();
        String name = MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createTable(name);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("jdbcUrl", dbConnectionUrl);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "JDBC", false, options);
        InternalDataConnectionService dlService = Accessors.getNodeEngineImpl((HazelcastInstance)MappingJdbcSqlConnectorTest.instance()).getDataConnectionService();
        Assertions.assertThat((boolean)dlService.existsSqlDataConnection(dcName)).isTrue();
        MappingJdbcSqlConnectorTest.createJdbcMappingUsingDataConnection(name, dcName);
        try (SqlResult mappings = sqlService.execute("SHOW MAPPINGS", new Object[0]);){
            Iterator resultIt = mappings.iterator();
            Assertions.assertThat((boolean)resultIt.hasNext()).isTrue();
            Object object = ((SqlRow)resultIt.next()).getObject(0);
            Assertions.assertThat((boolean)resultIt.hasNext()).isFalse();
            Assertions.assertThat((Object)object).isEqualTo((Object)name);
        }
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
    }

    @Test
    public void given_mappingIsDeclaredWithDataConn_when_DataConnWasRemoved_then_success() throws Exception {
        String dcName = MappingJdbcSqlConnectorTest.randomName();
        String mappingName = MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createTable(mappingName);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("jdbcUrl", dbConnectionUrl);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "JDBC", false, options);
        MappingJdbcSqlConnectorTest.createJdbcMappingUsingDataConnection(mappingName, dcName);
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
        List<SqlTestSupport.Row> showDataConnections = MappingJdbcSqlConnectorTest.allRows("SHOW DATA CONNECTIONS ", sqlService);
        SqlTestSupport.Row expectedConnection = new SqlTestSupport.Row("testDatabaseRef", "Jdbc", SqlJsonTestSupport.jsonArray("Table"));
        Assertions.assertThat(showDataConnections).contains((Object[])new SqlTestSupport.Row[]{expectedConnection});
        List<SqlTestSupport.Row> showMappings = MappingJdbcSqlConnectorTest.allRows("SHOW MAPPINGS ", sqlService);
        Assertions.assertThat(showMappings).contains((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(mappingName)});
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + mappingName, new Object[0])).hasMessageContaining("com.hazelcast.core.HazelcastException: Data connection '" + dcName + "' not found");
        sqlService.executeUpdate("DROP MAPPING " + mappingName, new Object[0]);
    }

    @Test
    public void when_dataConnectionIsAltered_then_mappingsConnectorTypesAreUpdated() throws Exception {
        String dcName = MappingJdbcSqlConnectorTest.randomName();
        String mappingName = MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createTable(mappingName);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "JDBC", false, Collections.singletonMap("jdbcUrl", dbConnectionUrl));
        MappingJdbcSqlConnectorTest.createJdbcMappingUsingDataConnection(mappingName, dcName);
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "Kafka", false, Collections.singletonMap("A", "B"));
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM information_schema.mappings ", Collections.singletonList(new SqlTestSupport.Row("hazelcast", "public", mappingName, "\"" + mappingName + "\"", "Kafka", "{}")));
        sqlService.executeUpdate("DROP MAPPING " + mappingName, new Object[0]);
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
    }

    @Test
    public void when_dataConnectionIsDropped_then_cachedPlansAreInvalidated() throws Exception {
        String dcName = MappingJdbcSqlConnectorTest.randomName();
        String mappingName = MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createTable(mappingName);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "JDBC", false, Collections.singletonMap("jdbcUrl", dbConnectionUrl));
        MappingJdbcSqlConnectorTest.createJdbcMappingUsingDataConnection(mappingName, dcName);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("select count(*) from " + mappingName, new SqlTestSupport.Row(0L));
        Assertions.assertThat((int)MappingJdbcSqlConnectorTest.sqlServiceImpl(MappingJdbcSqlConnectorTest.instance()).getPlanCache().size()).isOne();
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
        ((AbstractIntegerAssert)Assertions.assertThat((int)MappingJdbcSqlConnectorTest.sqlServiceImpl(MappingJdbcSqlConnectorTest.instance()).getPlanCache().size()).as("Plan should be invalidated", new Object[0])).isZero();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("select count(*) from " + mappingName, new Object[0]).iterator().hasNext()).as("Cached plan is not used", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Mapping '" + mappingName + "' is invalid");
        sqlService.executeUpdate("DROP MAPPING " + mappingName, new Object[0]);
    }

    @Test
    public void when_dataConnectionIsAlteredToCorrect_then_usesNewConnectionType() throws Exception {
        String dcName = MappingJdbcSqlConnectorTest.randomName();
        String mappingName = MappingJdbcSqlConnectorTest.randomName();
        MappingJdbcSqlConnectorTest.createTable(mappingName);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "JDBC", false, Collections.singletonMap("jdbcUrl", dbConnectionUrl));
        MappingJdbcSqlConnectorTest.createJdbcMappingUsingDataConnection(mappingName, dcName);
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("select count(*) from " + mappingName, new SqlTestSupport.Row(0L));
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
        MappingJdbcSqlConnectorTest.createDataConnection(MappingJdbcSqlConnectorTest.instance(), dcName, "Kafka", false, Collections.singletonMap("A", "B"));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("select count(*) from " + mappingName, new Object[0]).iterator().hasNext()).as("Should detect change of data connection type", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Missing 'valueFormat' option");
        sqlService.executeUpdate("DROP MAPPING " + mappingName, new Object[0]);
        sqlService.executeUpdate("DROP DATA CONNECTION " + dcName, new Object[0]);
    }

    @Test
    public void createMappingAutoResolveColumns() throws Exception {
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        try (SqlResult result = sqlService.execute("SELECT * FROM " + this.tableName, new Object[0]);){
            SqlRowMetadata metadata = result.getRowMetadata();
            Assertions.assertThat((List)metadata.getColumns()).extracting(SqlColumnMetadata::getName).contains((Object[])new String[]{"id", "name"});
        }
    }

    @Test
    public void createMappingWithTextColumnType() throws Exception {
        Assumptions.assumeThat((Object)databaseProvider).isInstanceOfAny(new Class[]{MySQLDatabaseProvider.class, PostgresDatabaseProvider.class, H2DatabaseProvider.class});
        MappingJdbcSqlConnectorTest.executeJdbc("CREATE TABLE " + this.tableName + " (id INTEGER NOT NULL,name TEXT NOT NULL)");
        MappingJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        Assertions.assertThatCode(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING myMapping  EXTERNAL NAME " + this.tableName + " (id INTEGER, name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0])).doesNotThrowAnyException();
        MappingJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM myMapping", Collections.singletonList(new SqlTestSupport.Row(0, "name-0")));
    }

    @Test
    public void createMappingFails_tableExistInAnotherDatabase_externalNameOnlyTableName() throws SQLException {
        Assumptions.assumeThat((Object)databaseProvider).isInstanceOfAny(new Class[]{MySQLDatabaseProvider.class, PostgresDatabaseProvider.class});
        HazelcastInstance instance = MappingJdbcSqlConnectorTest.instance();
        Config config = instance.getConfig();
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        String newDBName = "db1";
        MappingJdbcSqlConnectorTest.executeJdbc("CREATE DATABASE " + newDBName);
        String newDbUrl = MappingJdbcSqlConnectorTest.urlForDatabaseName(newDBName);
        Properties properties = new Properties();
        properties.setProperty("jdbcUrl", newDbUrl);
        String NEW_TEST_DATABASE_REF = "testDatabaseRef1";
        config.addDataConnectionConfig(new DataConnectionConfig(NEW_TEST_DATABASE_REF).setType("jdbc").setProperties(properties));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " EXTERNAL NAME " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION " + NEW_TEST_DATABASE_REF, new Object[0])).isInstanceOf(HazelcastSqlException.class)).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Could not execute readDbFields for table");
    }

    @Test
    public void createMappingFails_tableExistInAnotherDatabase_externalNameFullName() throws SQLException {
        Assumptions.assumeThat((Object)databaseProvider).isInstanceOfAny(new Class[]{PostgresDatabaseProvider.class});
        HazelcastInstance instance = MappingJdbcSqlConnectorTest.instance();
        Config config = instance.getConfig();
        MappingJdbcSqlConnectorTest.createTable(this.tableName);
        String newDBName = "db2";
        MappingJdbcSqlConnectorTest.executeJdbc("CREATE DATABASE " + newDBName);
        String newDbUrl = MappingJdbcSqlConnectorTest.urlForDatabaseName(newDBName);
        Properties properties = new Properties();
        properties.setProperty("jdbcUrl", newDbUrl);
        String NEW_TEST_DATABASE_REF = "testDatabaseRef2";
        config.addDataConnectionConfig(new DataConnectionConfig(NEW_TEST_DATABASE_REF).setType("jdbc").setProperties(properties));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " EXTERNAL NAME " + newDBName + ".public." + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION " + NEW_TEST_DATABASE_REF, new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Could not execute readDbFields for table");
    }
}

