/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.config.Config;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.dataconnection.impl.DataConnectionTestUtil;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.test.IgnoreInJenkinsOnWindows;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.test.DockerTestUtil;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseRecordProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={IgnoreInJenkinsOnWindows.class})
public abstract class JdbcSqlTestSupport
extends SqlTestSupport {
    protected static final String TEST_DATABASE_REF = "testDatabaseRef";
    protected static TestDatabaseProvider databaseProvider;
    protected static TestDatabaseRecordProvider recordProvider;
    protected static String dbConnectionUrl;
    protected static SqlService sqlService;

    @BeforeClass
    public static void checkDockerEnabled() {
        DockerTestUtil.assumeDockerEnabled();
    }

    public static void initialize(TestDatabaseProvider provider) {
        Config config = JdbcSqlTestSupport.smallInstanceConfig();
        config.getJetConfig().getDefaultEdgeConfig().setQueueSize(16);
        JdbcSqlTestSupport.initialize(provider, config);
    }

    public static void initialize(TestDatabaseProvider provider, Config config) {
        databaseProvider = provider;
        recordProvider = provider.recordProvider();
        dbConnectionUrl = databaseProvider.createDatabase(JdbcSqlTestSupport.class.getSimpleName());
        config.addDataConnectionConfig(new DataConnectionConfig(TEST_DATABASE_REF).setType(databaseProvider.dataConnectionType()).setProperties(databaseProvider.properties()));
        JdbcSqlTestSupport.initialize((int)2, (Config)config);
        sqlService = JdbcSqlTestSupport.instance().getSql();
    }

    @AfterClass
    public static void afterClass() {
        if (databaseProvider != null) {
            databaseProvider.shutdown();
            databaseProvider = null;
            dbConnectionUrl = null;
        }
    }

    protected static String urlForDatabaseName(String databaseName) {
        return dbConnectionUrl.replace(JdbcSqlTestSupport.class.getSimpleName(), databaseName);
    }

    @Nonnull
    protected static String randomTableName() {
        return "table_" + JdbcSqlTestSupport.randomName();
    }

    protected static String quote(String ... parts) {
        return databaseProvider.quote(parts);
    }

    public static void createTable(String tableName) throws SQLException {
        JdbcSqlTestSupport.createTableNoQuote(JdbcSqlTestSupport.quote(tableName), JdbcSqlTestSupport.quote("id") + " INT PRIMARY KEY", JdbcSqlTestSupport.quote("name") + " VARCHAR(100)");
    }

    public static void createTable(String tableName, String ... columns) throws SQLException {
        JdbcSqlTestSupport.executeJdbc("CREATE TABLE " + JdbcSqlTestSupport.quote(tableName) + " (" + Stream.of(columns).map(s -> {
            int spaceIndex = s.indexOf(32);
            return JdbcSqlTestSupport.quote(s.substring(0, spaceIndex)) + s.substring(spaceIndex);
        }).collect(Collectors.joining(", ")) + ")");
    }

    public static void createTableNoQuote(String tableName) throws SQLException {
        JdbcSqlTestSupport.createTableNoQuote(tableName, JdbcSqlTestSupport.quote("id") + " INT PRIMARY KEY", JdbcSqlTestSupport.quote("name") + " VARCHAR(100)");
    }

    public static void createTableNoQuote(String tableName, String ... columns) throws SQLException {
        JdbcSqlTestSupport.executeJdbc("CREATE TABLE " + tableName + " (" + String.join((CharSequence)", ", columns) + ")");
    }

    public static void executeJdbc(String sql) throws SQLException {
        Objects.requireNonNull(dbConnectionUrl, "dbConnectionUrl must be set");
        try (Connection conn = DriverManager.getConnection(dbConnectionUrl);
             Statement stmt = conn.createStatement();){
            String[] parts;
            for (String part : parts = sql.split("\n\n")) {
                stmt.execute(part);
            }
        }
    }

    public static void executeJdbcWithQuotes(String sql, String tableName) throws SQLException {
        Objects.requireNonNull(dbConnectionUrl, "dbConnectionUrl must be set");
        String[] substrings = sql.split(" ");
        StringBuilder finalSql = new StringBuilder();
        for (String str : substrings) {
            if (str.equals(tableName)) {
                finalSql.append(JdbcSqlTestSupport.quote(str)).append(" ");
                continue;
            }
            finalSql.append(str).append(" ");
        }
        DataConnectionTestUtil.executeJdbc((String)dbConnectionUrl, (String)finalSql.toString());
    }

    public static void insertItems(String tableName, int start, int count) throws SQLException {
        int end = start + count;
        String sql = String.format("INSERT INTO %s VALUES(?, ?)", tableName);
        try (Connection conn = DriverManager.getConnection(dbConnectionUrl);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            for (int i = start; i < end; ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, String.format("name-%d", i));
                stmt.addBatch();
                stmt.clearParameters();
            }
            stmt.executeBatch();
        }
    }

    public static void insertItems(String tableName, int count) throws SQLException {
        JdbcSqlTestSupport.insertItems(JdbcSqlTestSupport.quote(tableName), 0, count);
    }

    public static void insertItemsNoQuote(String tableName, int count) throws SQLException {
        JdbcSqlTestSupport.insertItems(tableName, 0, count);
    }

    protected static void createMapping(String tableName) {
        JdbcSqlTestSupport.execute("CREATE MAPPING \"" + tableName + "\" ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    protected static void createMapping(String tableName, String mappingName) {
        JdbcSqlTestSupport.execute("CREATE MAPPING \"" + mappingName + "\" EXTERNAL NAME " + tableName + "  ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    protected static void createJdbcMappingUsingDataConnection(String name, String dataConnection) {
        try (SqlResult result = JdbcSqlTestSupport.instance().getSql().execute("CREATE OR REPLACE MAPPING " + name + " DATA CONNECTION " + JdbcSqlTestSupport.quoteName(dataConnection) + "\n", new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isZero();
        }
    }

    protected static void execute(String sql, Object ... arguments) {
        Objects.requireNonNull(dbConnectionUrl);
        SqlResult ignored = sqlService.execute(sql, arguments);
        if (ignored != null) {
            ignored.close();
        }
    }

    protected static void assertJdbcRowsAnyOrder(String tableName, SqlTestSupport.Row ... rows) {
        List<SqlTestSupport.Row> actualRows = JdbcSqlTestSupport.jdbcRowsTable(tableName);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(Arrays.asList(rows));
    }

    protected static void assertJdbcRowsAnyOrder(String tableName, List<Class<?>> columnTypes, SqlTestSupport.Row ... rows) {
        List<SqlTestSupport.Row> actualRows = JdbcSqlTestSupport.jdbcRowsTable(tableName, columnTypes);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(Arrays.asList(rows));
    }

    protected static void assertJdbcQueryRowsAnyOrder(String query, SqlTestSupport.Row ... rows) {
        List<SqlTestSupport.Row> actualRows = JdbcSqlTestSupport.jdbcRows(query);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(Arrays.asList(rows));
    }

    protected static void assertJdbcQueryRowsAnyOrder(String query, List<Class<?>> columnTypes, SqlTestSupport.Row ... rows) {
        List<SqlTestSupport.Row> actualRows = JdbcSqlTestSupport.jdbcRows(query, columnTypes);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(Arrays.asList(rows));
    }

    protected static List<SqlTestSupport.Row> jdbcRowsTable(String tableName) {
        return JdbcSqlTestSupport.jdbcRows("SELECT * FROM " + JdbcSqlTestSupport.quote(tableName));
    }

    protected static List<SqlTestSupport.Row> jdbcRowsTable(String tableName, List<Class<?>> columnType) {
        return JdbcSqlTestSupport.jdbcRows("SELECT * FROM " + JdbcSqlTestSupport.quote(tableName), columnType);
    }

    protected static void assertJdbcRowsAnyOrderNoQuote(String tableName, List<Class<?>> columnTypes, SqlTestSupport.Row ... rows) {
        List<SqlTestSupport.Row> actualRows = JdbcSqlTestSupport.jdbcRowsTableNoQuote(tableName, columnTypes);
        Assertions.assertThat(actualRows).containsExactlyInAnyOrderElementsOf(Arrays.asList(rows));
    }

    protected static List<SqlTestSupport.Row> jdbcRowsTableNoQuote(String tableName, List<Class<?>> columnType) {
        return JdbcSqlTestSupport.jdbcRows("SELECT * FROM " + tableName, columnType);
    }

    @Nonnull
    protected static List<SqlTestSupport.Row> jdbcRows(String query) {
        return JdbcSqlTestSupport.jdbcRows(query, dbConnectionUrl);
    }

    protected static List<SqlTestSupport.Row> jdbcRows(String query, List<Class<?>> columnType) {
        return JdbcSqlTestSupport.jdbcRows(query, dbConnectionUrl, columnType);
    }

    public static List<SqlTestSupport.Row> jdbcRows(String query, String connectionUrl) {
        return JdbcSqlTestSupport.jdbcRows(query, connectionUrl, null);
    }

    /*
     * Exception decompiling
     */
    public static List<SqlTestSupport.Row> jdbcRows(String query, String connectionUrl, List<Class<?>> columnTypes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

