/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcSqlConnectorStabilityTest
extends JdbcSqlTestSupport {
    protected static String tableName;

    @BeforeClass
    public static void beforeClass() throws Exception {
        JdbcSqlConnectorStabilityTest.initializeStabilityTest((TestDatabaseProvider)new H2DatabaseProvider());
    }

    public static void initializeStabilityTest(TestDatabaseProvider provider) throws Exception {
        JdbcSqlConnectorStabilityTest.initialize(provider);
        tableName = JdbcSqlConnectorStabilityTest.randomTableName();
        JdbcSqlConnectorStabilityTest.createTable(tableName);
        JdbcSqlConnectorStabilityTest.insertItems(tableName, 5);
        JdbcSqlConnectorStabilityTest.execute("CREATE MAPPING " + tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        databaseProvider.shutdown();
    }

    @Test
    public void dataConnectionDownShouldTimeout() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + tableName, new Object[0]).forEach((Consumer)ConsumerEx.noop())).isInstanceOf(HazelcastSqlException.class);
    }

    @Test
    public void dataConnectionDownShouldNotAffectUnrelatedQueries() {
        JdbcSqlConnectorStabilityTest.assertRowsAnyOrder("SELECT * FROM TABLE(generate_series(0, 4))", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0), new SqlTestSupport.Row(1), new SqlTestSupport.Row(2), new SqlTestSupport.Row(3), new SqlTestSupport.Row(4)}));
    }
}

