/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcInnerEquiJoinStreamToJdbcTest
extends JdbcSqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        JdbcInnerEquiJoinStreamToJdbcTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Test
    public void joinWithTableValuedFunction_small_table_on_right() throws Exception {
        String tableName = "table1";
        JdbcInnerEquiJoinStreamToJdbcTest.createTable(tableName, "id INT PRIMARY KEY", "name VARCHAR(100)", "ssn INT DEFAULT 1");
        JdbcInnerEquiJoinStreamToJdbcTest.addWorkers(tableName, 3);
        JdbcInnerEquiJoinStreamToJdbcTest.execute("CREATE MAPPING " + tableName + " ( id INT,  name VARCHAR,  ssn INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        String sql = "SELECT n.id, n.name, n.ssn , t.v FROM (SELECT v FROM TABLE(generate_stream(1000))) t JOIN " + tableName + " n ON t.v = n.id LIMIT 3";
        List<SqlTestSupport.Row> actualList = this.getRows(sql);
        Assertions.assertThat(actualList).containsExactlyInAnyOrder((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(1, "myworker1", 208, 1L), new SqlTestSupport.Row(2, "myworker2", 209, 2L), new SqlTestSupport.Row(3, "myworker3", 210, 3L)});
    }

    private List<SqlTestSupport.Row> getRows(String sql) {
        ArrayList<SqlTestSupport.Row> actualList = new ArrayList<SqlTestSupport.Row>();
        try (SqlResult sqlResult = sqlService.execute(sql, new Object[0]);){
            Iterator iterator = sqlResult.iterator();
            iterator.forEachRemaining(row -> actualList.add(new SqlTestSupport.Row((SqlRow)row)));
        }
        return actualList;
    }

    private static void addWorkers(String tableName, int count) throws SQLException {
        for (int index = 1; index <= count; ++index) {
            String sql = JdbcInnerEquiJoinStreamToJdbcTest.getInsertWorkerSQL(tableName, index);
            JdbcInnerEquiJoinStreamToJdbcTest.executeJdbc(sql);
        }
    }

    private static String getWorkerName(int index) {
        return "myworker" + index;
    }

    private static int getSSN(int index) {
        return 207 + index;
    }

    private static String getInsertWorkerSQL(String tableName, int index) {
        return String.format("INSERT INTO %s VALUES(%d, '%s', %d)", tableName, index, JdbcInnerEquiJoinStreamToJdbcTest.getWorkerName(index), JdbcInnerEquiJoinStreamToJdbcTest.getSSN(index));
    }
}

