/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.impl.JdbcDataConnection;
import com.hazelcast.dataconnection.impl.JdbcDataConnectionTest;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcFullScanJoinTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        JdbcFullScanJoinTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(this.tableName);
        JdbcFullScanJoinTest.insertItems(this.tableName, 5);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    private static String getInsertSQL(String tableName, int id, String workerName) {
        return String.format("INSERT INTO %s VALUES(%d, '%s')", JdbcFullScanJoinTest.quote(tableName), id, workerName);
    }

    @Test
    public void selfJoin() throws SQLException {
        String tableName = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(tableName, "id INT PRIMARY KEY", "name VARCHAR(100)");
        String sql = JdbcFullScanJoinTest.getInsertSQL(tableName, 1, "Alice");
        JdbcFullScanJoinTest.executeJdbc(sql);
        sql = JdbcFullScanJoinTest.getInsertSQL(tableName, 2, "Barry");
        JdbcFullScanJoinTest.executeJdbc(sql);
        sql = JdbcFullScanJoinTest.getInsertSQL(tableName, 3, "Carol");
        JdbcFullScanJoinTest.executeJdbc(sql);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcFullScanJoinTest.assertRowsAnyOrder("SELECT t1.name AS employee1, t2.name AS employee2 FROM " + tableName + " t1 JOIN " + tableName + " t2    ON LENGTH(t1.name) = LENGTH(t2.name) AND t1.id < t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("Alice", "Barry"), new SqlTestSupport.Row("Alice", "Carol"), new SqlTestSupport.Row("Barry", "Carol")}));
    }

    @Test
    public void thetaJoin() throws SQLException {
        String otherTableName = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(otherTableName);
        String sql = JdbcFullScanJoinTest.getInsertSQL(otherTableName, 1, "name-1");
        JdbcFullScanJoinTest.executeJdbc(sql);
        sql = JdbcFullScanJoinTest.getInsertSQL(otherTableName, 2, "a");
        JdbcFullScanJoinTest.executeJdbc(sql);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        String selectSql = "SELECT t1.name, t1.id, t2.id , t2.name FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.name <= t2.name";
        JdbcFullScanJoinTest.assertRowsAnyOrder(selectSql, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("name-0", 0, 1, "name-1"), new SqlTestSupport.Row("name-1", 1, 1, "name-1")}));
    }

    @Test
    public void thetaJoinByPrimaryKey() throws SQLException {
        String otherTableName = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(otherTableName);
        String sql = JdbcFullScanJoinTest.getInsertSQL(otherTableName, 1, "othername-1");
        JdbcFullScanJoinTest.executeJdbc(sql);
        sql = JdbcFullScanJoinTest.getInsertSQL(otherTableName, 2, "othername-2");
        JdbcFullScanJoinTest.executeJdbc(sql);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        String selectSql = "SELECT t1.name, t1.id, t2.id , t2.name FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.id < t2.id";
        JdbcFullScanJoinTest.assertRowsAnyOrder(selectSql, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("name-0", 0, 1, "othername-1"), new SqlTestSupport.Row("name-0", 0, 2, "othername-2"), new SqlTestSupport.Row("name-1", 1, 2, "othername-2")}));
    }

    @Test
    public void thetaJoinByPrimaryKey_traverser_is_closed() throws SQLException {
        String jdbcDataConnection = "jdbc_data_connection";
        JdbcFullScanJoinTest.execute("CREATE DATA CONNECTION " + jdbcDataConnection + " TYPE Jdbc OPTIONS('jdbcUrl'= '" + dbConnectionUrl + "', 'maximumPoolSize'='64')", new Object[0]);
        int count = 500;
        String tableName0 = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(tableName0);
        JdbcFullScanJoinTest.insertItems(tableName0, count);
        String tableName1 = JdbcFullScanJoinTest.randomTableName();
        JdbcFullScanJoinTest.createTable(tableName1);
        JdbcFullScanJoinTest.insertItems(tableName1, count);
        DataSource dataSource0 = JdbcFullScanJoinTest.getDataSource(0, jdbcDataConnection);
        DataSource dataSource1 = JdbcFullScanJoinTest.getDataSource(1, jdbcDataConnection);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + tableName0 + " ( id INT,  name VARCHAR ) DATA CONNECTION " + jdbcDataConnection, new Object[0]);
        JdbcFullScanJoinTest.execute("CREATE MAPPING " + tableName1 + " ( id INT,  name VARCHAR ) DATA CONNECTION " + jdbcDataConnection, new Object[0]);
        String selectSql = "SELECT t1.name, t1.id, t2.id , t2.name FROM " + tableName0 + " t1 JOIN " + tableName1 + " t2    ON t1.id < t2.id LIMIT 2";
        List<SqlTestSupport.Row> rows = JdbcFullScanJoinTest.allRows(selectSql, sqlService);
        Assertions.assertThat(rows).hasSize(2);
        JdbcFullScanJoinTest.execute("DROP DATA CONNECTION " + jdbcDataConnection, new Object[0]);
        JdbcFullScanJoinTest.assertTrueEventually((String)"dataSources should be closed", () -> {
            Assertions.assertThat((boolean)JdbcDataConnectionTest.isClosed((DataSource)dataSource0)).isTrue();
            Assertions.assertThat((boolean)JdbcDataConnectionTest.isClosed((DataSource)dataSource1)).isTrue();
        }, (long)10L);
    }

    private static DataSource getDataSource(int instanceNumber, String dataConnectionName) {
        JdbcDataConnection jdbcDataConnection = (JdbcDataConnection)JdbcFullScanJoinTest.getDataConnectionService((HazelcastInstance)JdbcFullScanJoinTest.instances()[instanceNumber]).getAndRetainDataConnection(dataConnectionName, JdbcDataConnection.class);
        DataSource dataSource = JdbcDataConnectionTest.pooledDataSource((JdbcDataConnection)jdbcDataConnection);
        jdbcDataConnection.release();
        return dataSource;
    }
}

