/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
public class CreateDataConnectionJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    @Parameterized.Parameter
    public String value;

    @Parameterized.Parameters(name="value={0}")
    public static List<Object[]> data() {
        return Arrays.asList({"NOT SHARED"}, {"SHARED"});
    }

    @BeforeClass
    public static void beforeClass() {
        CreateDataConnectionJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Test
    public void createDataConnection() {
        String connectionName = CreateDataConnectionJdbcSqlConnectorTest.randomName();
        String sql = String.format("CREATE DATA CONNECTION %s TYPE JDBC %s OPTIONS('jdbcUrl'='%s')", connectionName, this.value, dbConnectionUrl);
        Assertions.assertThatCode(() -> CreateDataConnectionJdbcSqlConnectorTest.execute(sql, new Object[0])).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> CreateDataConnectionJdbcSqlConnectorTest.execute("SHOW RESOURCES FOR " + connectionName, new Object[0])).doesNotThrowAnyException();
    }

    @Test
    public void createDataConnectionWithPasswordInProperties() {
        Assumptions.assumeThat((Object)databaseProvider).isNotInstanceOfAny(new Class[]{H2DatabaseProvider.class});
        String connectionName = CreateDataConnectionJdbcSqlConnectorTest.randomName();
        String sql = String.format("CREATE DATA CONNECTION %s TYPE JDBC %s OPTIONS('jdbcUrl'='%s', 'user'='%s', 'password'='%s')", connectionName, this.value, databaseProvider.noAuthJdbcUrl(), databaseProvider.user(), databaseProvider.password());
        Assertions.assertThatCode(() -> CreateDataConnectionJdbcSqlConnectorTest.execute(sql, new Object[0])).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> CreateDataConnectionJdbcSqlConnectorTest.execute("SHOW RESOURCES FOR " + connectionName, new Object[0])).doesNotThrowAnyException();
    }
}

