/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.util.Lists;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AllTypesSelectJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    @Parameterized.Parameter
    public String type;
    @Parameterized.Parameter(value=1)
    public String mappingType;
    @Parameterized.Parameter(value=2)
    public String value;
    @Parameterized.Parameter(value=3)
    public Object expected;

    @Parameterized.Parameters(name="type:{0}, mappingType:{1}, value:{2}, expected:{3}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"VARCHAR(100)", "VARCHAR", "'dummy'", "dummy"}, {"CHAR(3)", "VARCHAR", "'try'", "try"}, {"BOOLEAN", "BOOLEAN", "TRUE", true}, {"TINYINT", "TINYINT", "1", (byte)1}, {"SMALLINT", "SMALLINT", "2", (short)2}, {"INTEGER", "INTEGER", "3", 3}, {"BIGINT", "BIGINT", "4", 4L}, {"DECIMAL (10,5)", "DECIMAL", "1.12345", new BigDecimal("1.12345")}, {"REAL", "REAL", "1.5", Float.valueOf(1.5f)}, {"DOUBLE", "DOUBLE", "1.8", 1.8}, {"DATE", "DATE", "'2022-12-30'", LocalDate.of(2022, 12, 30)}, {"TIME", "TIME", "'23:59:59'", LocalTime.of(23, 59, 59)}, {"TIMESTAMP", "TIMESTAMP", "'2022-12-30 23:59:59'", LocalDateTime.of(2022, 12, 30, 23, 59, 59)}, {"TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE", "'2022-12-30 23:59:59 -05:00'", OffsetDateTime.of(2022, 12, 30, 23, 59, 59, 0, ZoneOffset.ofHours(-5))});
    }

    @BeforeClass
    public static void beforeClass() {
        AllTypesSelectJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Test
    public void selectRowWithAllTypes() throws Exception {
        String tableName = AllTypesSelectJdbcSqlConnectorTest.randomTableName();
        AllTypesSelectJdbcSqlConnectorTest.createTable(tableName, "table_column " + this.type);
        AllTypesSelectJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + AllTypesSelectJdbcSqlConnectorTest.quote(tableName) + " VALUES(" + this.value + ")");
        String mappingName = "mapping_" + AllTypesSelectJdbcSqlConnectorTest.randomName();
        AllTypesSelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + mappingName + " EXTERNAL NAME " + tableName + " (table_column " + this.mappingType + ") DATA CONNECTION testDatabaseRef", new Object[0]);
        AllTypesSelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + mappingName, new SqlTestSupport.Row(this.expected));
        AllTypesSelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT table_column FROM " + mappingName + " WHERE table_column = ?", (List<Object>)Lists.newArrayList((Object[])new Object[]{this.expected}), new SqlTestSupport.Row(this.expected));
    }

    @Test
    public void resolveMappingType() throws Exception {
        String tableName = AllTypesSelectJdbcSqlConnectorTest.randomTableName();
        AllTypesSelectJdbcSqlConnectorTest.createTable(tableName, "table_column " + this.type);
        AllTypesSelectJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + AllTypesSelectJdbcSqlConnectorTest.quote(tableName) + " VALUES(" + this.value + ")");
        String mappingName = "mapping_" + AllTypesSelectJdbcSqlConnectorTest.randomName();
        AllTypesSelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + mappingName + " EXTERNAL NAME " + tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        AllTypesSelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT data_type FROM information_schema.columns WHERE table_name = ?", (List<Object>)Lists.newArrayList((Object[])new Object[]{mappingName}), new SqlTestSupport.Row(this.mappingType));
    }
}

