/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AllTypesInsertJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    @Parameterized.Parameter
    public String type;
    @Parameterized.Parameter(value=1)
    public String mappingType;
    @Parameterized.Parameter(value=2)
    public String sqlValue;
    @Parameterized.Parameter(value=3)
    public Object javaValue;
    @Parameterized.Parameter(value=4)
    public Object jdbcValue;

    @Parameterized.Parameters(name="type:{0}, mappingType:{1}, sqlValue:{2}, javaValue:{3}, jdbcValue:{4}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"VARCHAR(10)", "VARCHAR", "'dummy'", "dummy", "dummy"}, {"CHAR(3)", "VARCHAR", "'try'", "try", "try"}, {"BOOLEAN", "BOOLEAN", "TRUE", true, true}, {"TINYINT", "TINYINT", "1", 1, 1}, {"SMALLINT", "SMALLINT", "2", 2, 2}, {"INTEGER", "INTEGER", "3", 3, 3}, {"BIGINT", "BIGINT", "4", 4L, 4L}, {"DECIMAL (10,5)", "DECIMAL", "1.12345", new BigDecimal("1.12345"), new BigDecimal("1.12345")}, {"REAL", "REAL", "1.5", Float.valueOf(1.5f), Float.valueOf(1.5f)}, {"DOUBLE", "DOUBLE", "1.8", 1.8, 1.8}, {"DATE", "DATE", "'2022-12-30'", LocalDate.of(2022, 12, 30), Date.valueOf("2022-12-30")}, {"TIME", "TIME", "'23:59:59'", LocalTime.of(23, 59, 59), Time.valueOf("23:59:59")}, {"TIMESTAMP", "TIMESTAMP", "'2022-12-30 23:59:59'", LocalDateTime.of(2022, 12, 30, 23, 59, 59), Timestamp.valueOf("2022-12-30 23:59:59")}, {"TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE", "'2022-12-30T23:59:59-05:00'", OffsetDateTime.of(2022, 12, 30, 23, 59, 59, 0, ZoneOffset.ofHours(-5)), OffsetDateTime.of(2022, 12, 30, 23, 59, 59, 0, ZoneOffset.ofHours(-5))});
    }

    @BeforeClass
    public static void beforeClass() {
        AllTypesInsertJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Test
    public void insertRowWithAllTypes() throws Exception {
        String tableName = AllTypesInsertJdbcSqlConnectorTest.randomTableName();
        AllTypesInsertJdbcSqlConnectorTest.createTable(tableName, "id INT", "table_column " + this.type);
        String mappingName = "mapping_" + AllTypesInsertJdbcSqlConnectorTest.randomName();
        AllTypesInsertJdbcSqlConnectorTest.execute("CREATE MAPPING " + mappingName + " EXTERNAL NAME " + tableName + " (id INT, table_column " + this.mappingType + ") DATA CONNECTION testDatabaseRef", new Object[0]);
        AllTypesInsertJdbcSqlConnectorTest.execute("INSERT INTO " + mappingName + " VALUES(0, " + this.sqlValue + ")", new Object[0]);
        AllTypesInsertJdbcSqlConnectorTest.execute("INSERT INTO " + mappingName + " VALUES(1, ?)", this.javaValue);
        AllTypesInsertJdbcSqlConnectorTest.assertJdbcQueryRowsAnyOrder("SELECT " + databaseProvider.quote(new String[]{"table_column"}) + " FROM " + databaseProvider.quote(new String[]{tableName}), List.of(this.jdbcValue.getClass()), new SqlTestSupport.Row(this.jdbcValue), new SqlTestSupport.Row(this.jdbcValue));
    }
}

