/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingsTable;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MappingsTableTest {
    @Test
    public void test_rows() {
        Mapping mapping = new Mapping("table-name", new String[]{"external-schema", "table-external-name"}, null, "table-type", null, Collections.emptyList(), Collections.singletonMap("key", "value"));
        MappingsTable mappingTable = new MappingsTable("catalog", null, "table-schema", Collections.singletonList(mapping), null, s -> (String)Assertions.fail((String)"Should not be invoked"), false);
        List rows = mappingTable.rows();
        Assertions.assertThat((List)rows).containsExactly((Object[])new Object[][]{{"catalog", "table-schema", "table-name", "\"external-schema\".\"table-external-name\"", "table-type", "{\"key\":\"value\"}"}});
    }

    @Test
    public void test_rows_security_enabled() {
        Mapping mapping = new Mapping("table-name", new String[]{"external-schema", "table-external-name"}, null, "IMap", null, Collections.emptyList(), Collections.singletonMap("key", "value"));
        MappingsTable mappingTable = new MappingsTable("catalog", null, "table-schema", Collections.singletonList(mapping), (SqlConnectorCache)Mockito.mock(SqlConnectorCache.class, (Answer)Mockito.RETURNS_MOCKS), s -> (String)Assertions.fail((String)"Should not be invoked"), true);
        List rows = mappingTable.rows();
        Assertions.assertThat((List)rows).containsExactly((Object[])new Object[][]{{"catalog", "table-schema", "table-name", "\"external-schema\".\"table-external-name\"", "IMap", "{}"}});
    }

    @Test
    public void test_rows_dataconnection() {
        Mapping mapping = new Mapping("table-name", new String[]{"external-schema", "table-external-name"}, "some-dc", null, null, Collections.emptyList(), Collections.singletonMap("key", "value"));
        MappingsTable mappingTable = new MappingsTable("catalog", null, "table-schema", Collections.singletonList(mapping), null, dc -> {
            Assertions.assertThat((String)dc).isEqualTo("some-dc");
            return "external-dc-type";
        }, false);
        List rows = mappingTable.rows();
        Assertions.assertThat((List)rows).containsExactly((Object[])new Object[][]{{"catalog", "table-schema", "table-name", "\"external-schema\".\"table-external-name\"", "external-dc-type", "{\"key\":\"value\"}"}});
    }
}

