/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.DataConnectionsTable;
import com.hazelcast.jet.sql.impl.connector.kafka.KafkaSqlConnector;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DataConnectionsTableTest {
    @Mock
    SqlConnectorCache connectorCache;
    private AutoCloseable openMocks;

    @Before
    public void before() throws Exception {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @After
    public void tearDown() throws Exception {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    public void test_rows() {
        DataConnectionCatalogEntry dc = new DataConnectionCatalogEntry("dc-name", "dc-type", false, Collections.singletonMap("key", "value"));
        DataConnectionsTable dcTable = new DataConnectionsTable("catalog", "public", "dc-schema", Collections.singletonList(dc), this.connectorCache, false);
        List rows = dcTable.rows();
        Assertions.assertThat((List)rows).containsExactly((Object[])new Object[][]{{"catalog", "dc-schema", "dc-name", "dc-type", false, "{\"key\":\"value\"}", "SQL"}});
    }

    @Test
    public void test_rows_enabledSecurity() {
        Mockito.when((Object)this.connectorCache.forType("Kafka")).thenReturn((Object)new KafkaSqlConnector());
        DataConnectionCatalogEntry dc = new DataConnectionCatalogEntry("dc-name", "Kafka", false, Map.of("bootstrap.servers", "value", "password", "secret"));
        DataConnectionsTable dcTable = new DataConnectionsTable("catalog", "public", "dc-schema", Collections.singletonList(dc), this.connectorCache, true);
        List rows = dcTable.rows();
        Assertions.assertThat((List)rows).containsExactly((Object[])new Object[][]{{"catalog", "dc-schema", "dc-name", "Kafka", false, "{\"bootstrap.servers\":\"value\"}", "SQL"}});
    }
}

