/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlCsvTest
extends SqlTestSupport {
    private static final String RESOURCES_PATH = Paths.get("src/test/resources", new String[0]).toFile().getAbsolutePath();
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlCsvTest.initialize((int)1, null);
        sqlService = SqlCsvTest.instance().getSql();
    }

    @Test
    public void test_nulls() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (nonExistingField VARCHAR) TYPE File OPTIONS ('format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_dynamicParameters() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE File OPTIONS ('format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT CAST(long AS BIGINT) - ? FROM " + name + " WHERE byte = ?", Arrays.asList((byte)3, "127"), Collections.singletonList(new SqlTestSupport.Row(0x7FFFFFFFFFFFFFFCL)));
    }

    @Test
    public void test_fieldsMapping() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (id TINYINT EXTERNAL NAME byte, name VARCHAR EXTERNAL NAME string) TYPE File OPTIONS ('format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT id, name FROM " + name, Collections.singletonList(new SqlTestSupport.Row((byte)127, "string")));
    }

    @Test
    public void test_allTypes() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (string VARCHAR, \"boolean\" BOOLEAN, byte TINYINT, short SMALLINT, \"int\" INT, long BIGINT, \"float\" REAL, \"double\" DOUBLE, \"decimal\" DECIMAL, \"time\" TIME, \"date\" DATE, \"timestamp\" TIMESTAMP, timestampTz TIMESTAMP WITH TIME ZONE, object OBJECT) TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row("string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), null)));
    }

    @Test
    public void test_schemaDiscovery() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\" FROM " + name, Collections.singletonList(new SqlTestSupport.Row("string", "true", "127", "32767", "2147483647", "9223372036854775807", "1234567890.1", "123451234567890.1", "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z")));
    }

    @Test
    public void test_tableFunction() {
        SqlCsvTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\" FROM TABLE (csv_file (path => '" + RESOURCES_PATH + "', options => MAP['key', 'value'], glob => 'file.csv'))", Collections.singletonList(new SqlTestSupport.Row("string", "true", "127", "32767", "2147483647", "9223372036854775807", "1234567890.1", "123451234567890.1", "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z")));
    }

    @Test
    public void test_tableFunctionWithExplicitNullArgument() {
        SqlCsvTest.assertRowsAnyOrder("SELECT string, \"int\" FROM TABLE (csv_file (path => '" + RESOURCES_PATH + "', options => null, glob => 'file.csv'))", Collections.singletonList(new SqlTestSupport.Row("string", "2147483647")));
    }

    @Test
    public void test_tableFunctionWithArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE (csv_file (path => '" + RESOURCES_PATH + "', glob => MAP['key', 'value']))", new Object[0])).hasMessageContaining("Cannot apply 'CSV_FILE' function to [VARCHAR, MAP]");
    }

    @Test
    public void test_tableFunctionWithUnknownParameter() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE (csv_file (non_existing => 1))", new Object[0])).hasMessageContaining("Unknown argument name 'non_existing'");
    }

    @Test
    public void test_tableFunctionWithDynamicParameters() {
        SqlCsvTest.assertRowsAnyOrder("SELECT CAST(long AS BIGINT) - ? FROM TABLE (csv_file (path => ?, glob => ?, options => MAP[?, ?]))WHERE byte = ?", Arrays.asList(6, RESOURCES_PATH, "file.csv", "key", "value", "127"), Collections.singletonList(new SqlTestSupport.Row(0x7FFFFFFFFFFFFFF9L)));
    }

    @Test
    public void test_tableFunctionWithDynamicParametersAndArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE (csv_file (path => '" + RESOURCES_PATH + "', glob => ?))", new Object[]{1})).hasMessageContaining("Parameter at position 0 must be of VARCHAR type, but INTEGER was found");
    }

    @Test
    public void when_conversionFails_then_queryFails() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (string INT) TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).hasMessageContaining("Cannot parse VARCHAR value to INTEGER");
    }

    @Test
    public void when_columnsSpecified_then_fileNotAccessed() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (field INT) TYPE File OPTIONS ( 'format'='csv', 'path'='/non-existent-directory', 'glob'='foo.csv')", new Object[0]);
    }

    @Test
    public void when_fileDoesNotExist_then_fails() {
        String name = SqlCsvTest.randomName();
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING " + name + " TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='foo.csv')", new Object[0])).hasMessageContaining("matches no files");
    }

    @Test
    public void when_fileDoesNotExistAndIgnoreFileNotFound_then_returnNoResults() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (field INT)  TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='foo.csv', 'ignoreFileNotFound'='true')", new Object[0]);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).describedAs("no results from non existing file", new Object[0])).isFalse();
    }

    @Test
    public void when_directoryDoesNotExist_then_tableFunctionThrowsException() {
        String path = SqlCsvTest.hadoopNonExistingPath();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE (csv_file (path => '" + path + "'))", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("The directory '" + path + "' does not exist");
    }

    @Test
    public void when_fileDoesNotExist_then_tableFunctionThrowsException() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT *  FROM TABLE (csv_file ( path => '" + RESOURCES_PATH + "' , glob => 'foo.csv'))", new Object[0])).hasMessageContaining("matches no files");
    }

    @Test
    public void test_duplicateExternalName() {
        String name = SqlCsvTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (long BIGINT EXTERNAL NAME long,long_again BIGINT EXTERNAL NAME long) TYPE File OPTIONS ( 'format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='file.csv')", new Object[0]);
        SqlCsvTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(Long.MAX_VALUE, Long.MAX_VALUE)));
    }
}

