/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.connector.file.AvroResolver;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AvroResolverTest {
    @Test
    public void test_resolveFields() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"name").fields().name("boolean").type().booleanType().noDefault().name("int").type().intType().noDefault().name("long").type().longType().noDefault().name("float").type().floatType().noDefault().name("double").type().doubleType().noDefault().name("string").type().stringType().noDefault().name("object").type().record("object").fields().endRecord()).noDefault().endRecord();
        List fields = AvroResolver.resolveFields((Schema)schema);
        HazelcastTestSupport.assertIterableEquals((Iterable)fields, (Object[])new Object[]{new MappingField("boolean", QueryDataType.BOOLEAN), new MappingField("int", QueryDataType.INT), new MappingField("long", QueryDataType.BIGINT), new MappingField("float", QueryDataType.REAL), new MappingField("double", QueryDataType.DOUBLE), new MappingField("string", QueryDataType.VARCHAR), new MappingField("object", QueryDataType.OBJECT)});
    }

    @Test
    public void test_resolveNullableFields() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)SchemaBuilder.record((String)"name").fields().name("boolean").type().nullable().booleanType().noDefault().name("int").type().nullable().intType().noDefault().name("long").type().nullable().longType().noDefault().name("float").type().nullable().floatType().noDefault().name("double").type().nullable().doubleType().noDefault().name("string").type().nullable().stringType().noDefault().name("object").type().nullable().record("object").fields().endRecord()).noDefault().endRecord();
        List fields = AvroResolver.resolveFields((Schema)schema);
        HazelcastTestSupport.assertIterableEquals((Iterable)fields, (Object[])new Object[]{new MappingField("boolean", QueryDataType.BOOLEAN), new MappingField("int", QueryDataType.INT), new MappingField("long", QueryDataType.BIGINT), new MappingField("float", QueryDataType.REAL), new MappingField("double", QueryDataType.DOUBLE), new MappingField("string", QueryDataType.VARCHAR), new MappingField("object", QueryDataType.OBJECT)});
    }
}

