/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.sql.impl.connector.RowProjector;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RowProjectorTest {
    @Test
    public void test_project() {
        RowProjector projector = new RowProjector(new String[]{"target"}, new QueryDataType[]{QueryDataType.INT}, (QueryTarget)new IdentityTarget(), null, Collections.singletonList(MultiplyFunction.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT)), (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class));
        JetSqlRow row = projector.project((Object)1);
        Assertions.assertThat((Object[])row.getValues()).isEqualTo((Object)new Object[]{2});
    }

    @Test
    public void when_filteredByPredicate_then_returnsNull() {
        RowProjector projector = new RowProjector(new String[]{"target"}, new QueryDataType[]{QueryDataType.INT}, (QueryTarget)new IdentityTarget(), (Expression)ConstantExpression.create((Object)Boolean.FALSE, (QueryDataType)QueryDataType.BOOLEAN), Collections.emptyList(), (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class));
        JetSqlRow row = projector.project((Object)1);
        Assertions.assertThat((Object)row).isNull();
    }

    private static final class IdentityTarget
    implements QueryTarget {
        private Object value;

        private IdentityTarget() {
        }

        public void setTarget(Object value, Data valueData) {
            assert (valueData == null);
            this.value = value;
        }

        public QueryExtractor createExtractor(String path, QueryDataType type) {
            return () -> this.value;
        }
    }
}

