/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.cache;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.optimizer.PlanCheckContext;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;

public abstract class PlanCacheTestSupport
extends SqlTestSupport {
    protected static final Map<UUID, PartitionIdSet> PART_MAP_1;
    protected static final Map<UUID, PartitionIdSet> PART_MAP_2;

    public static PlanKey createKey(String sql) {
        return new PlanKey(Collections.emptyList(), sql);
    }

    public static SqlPlan createPlan(PlanKey key, Map<UUID, PartitionIdSet> partitions, int ... objectKeys) {
        HashSet<PlanObjectKey> objectKeys0 = new HashSet<PlanObjectKey>();
        if (objectKeys != null) {
            for (int objectId : objectKeys) {
                objectKeys0.add(PlanCacheTestSupport.createObjectId(objectId));
            }
        }
        TestPlan plan = new TestPlan(key, objectKeys0, partitions);
        Assert.assertEquals((Object)key, (Object)plan.getPlanKey());
        Assert.assertEquals((long)0L, (long)plan.getPlanLastUsed());
        return plan;
    }

    public static PlanObjectKey createObjectId(int value) {
        return new TestPlanObjectKey(value);
    }

    public static void advanceTime() {
        long currentTime = System.currentTimeMillis();
        try {
            do {
                Thread.sleep(10L);
            } while (System.currentTimeMillis() <= currentTime);
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
    }

    static {
        UUID memberId = UuidUtil.newSecureUUID();
        PartitionIdSet partitions1 = new PartitionIdSet(4);
        partitions1.add(0);
        partitions1.add(1);
        PartitionIdSet partitions2 = new PartitionIdSet(4);
        partitions2.add(2);
        partitions2.add(3);
        PART_MAP_1 = Collections.singletonMap(memberId, partitions1);
        PART_MAP_2 = Collections.singletonMap(memberId, partitions2);
    }

    private static class TestPlan
    extends SqlPlan {
        private final Set<PlanObjectKey> objectKeys;
        private final Map<UUID, PartitionIdSet> partitions;

        private TestPlan(PlanKey planKey, Set<PlanObjectKey> objectKeys, Map<UUID, PartitionIdSet> partitions) {
            super(planKey);
            this.objectKeys = objectKeys;
            this.partitions = partitions;
        }

        public boolean isCacheable() {
            return false;
        }

        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys, this.partitions);
        }

        public void checkPermissions(SqlSecurityContext context) {
        }

        public boolean producesRows() {
            return true;
        }

        public boolean supportsTimeout() {
            return true;
        }

        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout, SqlSecurityContext ssc) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestPlanObjectKey
    implements PlanObjectKey {
        private final int id;

        private TestPlanObjectKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestPlanObjectKey that = (TestPlanObjectKey)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

