/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.ValueSqlAggregation;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ValueSqlAggregationTest {
    @Test
    public void test_default() {
        ValueSqlAggregation aggregation = new ValueSqlAggregation();
        Assertions.assertThat((Object)aggregation.collect()).isNull();
    }

    @Test
    public void test_accumulate() {
        ValueSqlAggregation aggregation = new ValueSqlAggregation();
        aggregation.accumulate((Object)"v");
        aggregation.accumulate((Object)"v");
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)"v");
    }

    @Test
    public void test_combine() {
        ValueSqlAggregation left = new ValueSqlAggregation();
        left.accumulate(null);
        ValueSqlAggregation right = new ValueSqlAggregation();
        right.accumulate((Object)"v");
        left.combine((SqlAggregation)right);
        Assertions.assertThat((Object)left.collect()).isEqualTo((Object)"v");
        Assertions.assertThat((Object)right.collect()).isEqualTo((Object)"v");
    }

    @Test
    public void test_serialization() {
        ValueSqlAggregation original = new ValueSqlAggregation();
        original.accumulate((Object)"v");
        ValueSqlAggregation serialized = (ValueSqlAggregation)SqlTestSupport.TEST_SS.toObject((Object)SqlTestSupport.TEST_SS.toData((Object)original));
        Assert.assertEquals((Object)SqlTestSupport.TEST_SS.toData((Object)"v"), (Object)serialized.collect());
    }
}

