/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class UnionSlidingWindowAggregationTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        UnionSlidingWindowAggregationTest.initialize((int)1, null);
    }

    @Test
    public void test() {
        String stream1 = "stream_a";
        TestStreamSqlConnector.create(UnionSlidingWindowAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), UnionSlidingWindowAggregationTest.row(1, UnionSlidingWindowAggregationTest.timestampTz(1L)), UnionSlidingWindowAggregationTest.row(3, UnionSlidingWindowAggregationTest.timestampTz(3L)), UnionSlidingWindowAggregationTest.row(5, UnionSlidingWindowAggregationTest.timestampTz(5L)), UnionSlidingWindowAggregationTest.row(41, UnionSlidingWindowAggregationTest.timestampTz(41L)));
        String stream2 = "stream_b";
        TestStreamSqlConnector.create(UnionSlidingWindowAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(0L), 0), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(2L), 2), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(4L), 4), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(41L), 41));
        String stream3 = "stream_c";
        TestStreamSqlConnector.create(UnionSlidingWindowAggregationTest.instance().getSql(), stream3, Arrays.asList("e", "f"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(0L), 0), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(2L), 2), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(4L), 4), UnionSlidingWindowAggregationTest.row(UnionSlidingWindowAggregationTest.timestampTz(41L), 41));
        UnionSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_a, DESCRIPTOR(b), INTERVAL '0.003' SECOND))", new Object[0]);
        UnionSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_b, DESCRIPTOR(c), INTERVAL '0.003' SECOND))", new Object[0]);
        UnionSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s3 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_c, DESCRIPTOR(e), INTERVAL '0.003' SECOND))", new Object[0]);
        String sql = " SELECT window_start AS ws1, SUM(a) AS sum1 FROM     TABLE(TUMBLE(TABLE s1, DESCRIPTOR(b), INTERVAL '0.003' SECOND))    GROUP BY window_start  UNION ALL   SELECT window_start AS ws2, MAX(d) AS max2 FROM     TABLE(TUMBLE(TABLE s2, DESCRIPTOR(c), INTERVAL '0.003' SECOND))    GROUP BY window_start  UNION ALL   SELECT window_start AS ws3, COUNT(f) AS avg3 FROM     TABLE(TUMBLE(TABLE s3, DESCRIPTOR(e), INTERVAL '0.003' SECOND))    GROUP BY window_start";
        UnionSlidingWindowAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(0L), 1L), new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(0L), 2), new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(0L), 2L), new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(3L), 8L), new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(3L), 4), new SqlTestSupport.Row(UnionSlidingWindowAggregationTest.timestampTz(3L), 1L)));
    }
}

