/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SumSqlAggregations;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class SumSqlAggregationTest {
    private Object[] types() {
        return new Object[]{new Object[]{QueryDataType.TINYINT}, new Object[]{QueryDataType.SMALLINT}, new Object[]{QueryDataType.INT}, new Object[]{QueryDataType.BIGINT}, new Object[]{QueryDataType.DECIMAL}, new Object[]{QueryDataType.REAL}, new Object[]{QueryDataType.DOUBLE}};
    }

    @Test
    @Parameters(method="types")
    public void test_default(QueryDataType operandType) {
        SqlAggregation aggregation = SumSqlAggregations.from((QueryDataType)operandType, (boolean)false);
        Assertions.assertThat((Object)aggregation.collect()).isNull();
    }

    private Object[] values() {
        return new Object[]{new Object[]{QueryDataType.TINYINT, (byte)1, (byte)2, 3L}, new Object[]{QueryDataType.TINYINT, null, (byte)1, 1L}, new Object[]{QueryDataType.TINYINT, (byte)1, null, 1L}, new Object[]{QueryDataType.TINYINT, null, null, null}, new Object[]{QueryDataType.SMALLINT, (short)1, (short)2, 3L}, new Object[]{QueryDataType.SMALLINT, null, (short)1, 1L}, new Object[]{QueryDataType.SMALLINT, (short)1, null, 1L}, new Object[]{QueryDataType.SMALLINT, null, null, null}, new Object[]{QueryDataType.INT, 1, 2, 3L}, new Object[]{QueryDataType.INT, null, 1, 1L}, new Object[]{QueryDataType.INT, 1, null, 1L}, new Object[]{QueryDataType.INT, null, null, null}, new Object[]{QueryDataType.BIGINT, 1L, 2L, new BigDecimal(3)}, new Object[]{QueryDataType.BIGINT, null, 1L, new BigDecimal(1)}, new Object[]{QueryDataType.BIGINT, 1L, null, new BigDecimal(1)}, new Object[]{QueryDataType.BIGINT, null, null, null}, new Object[]{QueryDataType.DECIMAL, new BigDecimal(1), new BigDecimal(2), new BigDecimal(3)}, new Object[]{QueryDataType.DECIMAL, null, new BigDecimal(1), new BigDecimal(1)}, new Object[]{QueryDataType.DECIMAL, new BigDecimal(1), null, new BigDecimal(1)}, new Object[]{QueryDataType.DECIMAL, null, null, null}, new Object[]{QueryDataType.REAL, Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)}, new Object[]{QueryDataType.REAL, null, Float.valueOf(1.0f), Float.valueOf(1.0f)}, new Object[]{QueryDataType.REAL, Float.valueOf(1.0f), null, Float.valueOf(1.0f)}, new Object[]{QueryDataType.REAL, null, null, null}, new Object[]{QueryDataType.DOUBLE, 1.0, 2.0, 3.0}, new Object[]{QueryDataType.DOUBLE, null, 1.0, 1.0}, new Object[]{QueryDataType.DOUBLE, 1.0, null, 1.0}, new Object[]{QueryDataType.DOUBLE, null, null, null}};
    }

    @Test
    @Parameters(method="values")
    public void test_accumulate(QueryDataType operandType, Object value1, Object value2, Object expected) {
        SqlAggregation aggregation = SumSqlAggregations.from((QueryDataType)operandType, (boolean)false);
        aggregation.accumulate(value1);
        aggregation.accumulate(value2);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo(expected);
    }

    private Object[] values_susceptible_to_overflow() {
        return new Object[]{new Object[]{QueryDataType.TINYINT, (byte)1}, new Object[]{QueryDataType.SMALLINT, (short)1}, new Object[]{QueryDataType.INT, 1}};
    }

    @Test
    @Parameters(method="values_susceptible_to_overflow")
    public void test_accumulateOverflow(QueryDataType operandType, Object value) {
        SqlAggregation aggregation = SumSqlAggregations.from((QueryDataType)operandType, (boolean)false);
        aggregation.accumulate((Object)Long.MAX_VALUE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> aggregation.accumulate(value)).isInstanceOf(QueryException.class)).hasMessageContaining("BIGINT overflow");
    }

    private Object[] values_distinct() {
        return new Object[]{new Object[]{QueryDataType.TINYINT, Arrays.asList((byte)1, (byte)1, (byte)2), 3L}, new Object[]{QueryDataType.SMALLINT, Arrays.asList((short)1, (short)1, (short)2), 3L}, new Object[]{QueryDataType.INT, Arrays.asList(1, 1, 2), 3L}, new Object[]{QueryDataType.BIGINT, Arrays.asList(1L, 1L, 2L), new BigDecimal(3)}, new Object[]{QueryDataType.DECIMAL, Arrays.asList(new BigDecimal(1), new BigDecimal(1), new BigDecimal(2)), new BigDecimal(3)}, new Object[]{QueryDataType.REAL, Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(2.0f)), Float.valueOf(3.0f)}, new Object[]{QueryDataType.DOUBLE, Arrays.asList(1.0, 1.0, 2.0), 3.0}};
    }

    @Test
    @Parameters(method="values_distinct")
    public void test_accumulateDistinct(QueryDataType operandType, List<Object> values, Object expected) {
        SqlAggregation aggregation = SumSqlAggregations.from((QueryDataType)operandType, (boolean)true);
        aggregation.accumulate(null);
        values.forEach(arg_0 -> ((SqlAggregation)aggregation).accumulate(arg_0));
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo(expected);
    }

    @Test
    @Parameters(method="values")
    public void test_combine(QueryDataType operandType, Object value1, Object value2, Object expected) {
        SqlAggregation left = SumSqlAggregations.from((QueryDataType)operandType, (boolean)false);
        left.accumulate(value1);
        SqlAggregation right = SumSqlAggregations.from((QueryDataType)operandType, (boolean)false);
        right.accumulate(value2);
        left.combine(right);
        Assertions.assertThat((Object)left.collect()).isEqualTo(expected);
    }

    @Test
    public void test_serialization() {
        SqlAggregation original = SumSqlAggregations.from((QueryDataType)QueryDataType.BIGINT, (boolean)false);
        original.accumulate((Object)1L);
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        SqlAggregation serialized = (SqlAggregation)ss.toObject((Object)ss.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

