/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlTumbleTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() throws IOException {
        SqlTumbleTest.initialize((int)1, null);
        sqlService = SqlTumbleTest.instance().getSql();
    }

    @Test
    public void test_validArguments_tinyInt() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.TINYINT, "1", SqlTumbleTest.row((byte)0), SqlTumbleTest.row((byte)2));
    }

    @Test
    public void test_validArguments_smallInt() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.SMALLINT, "2", SqlTumbleTest.row((short)0), SqlTumbleTest.row((short)2));
    }

    @Test
    public void test_validArguments_int() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.INTEGER, "3", SqlTumbleTest.row(0), SqlTumbleTest.row(2));
    }

    @Test
    public void test_validArguments_bigInt() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.BIGINT, "4", SqlTumbleTest.row(0L), SqlTumbleTest.row(2L));
    }

    @Test
    public void test_validArguments_time() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.TIME, "INTERVAL '0.005' SECOND", SqlTumbleTest.row(SqlTumbleTest.time(0L)), SqlTumbleTest.row(SqlTumbleTest.time(2L)));
    }

    @Test
    public void test_validArguments_date() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.DATE, "INTERVAL '6' DAYS", SqlTumbleTest.row(SqlTumbleTest.date(0L)), SqlTumbleTest.row(SqlTumbleTest.date(2L)));
    }

    @Test
    public void test_validArguments_timestamp() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.TIMESTAMP, "INTERVAL '0.007' SECOND", SqlTumbleTest.row(SqlTumbleTest.timestamp(0L)), SqlTumbleTest.row(SqlTumbleTest.timestamp(2L)));
    }

    @Test
    public void test_validArguments_timestampTz() {
        SqlTumbleTest.checkValidArguments(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "INTERVAL '0.008' SECOND", SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L)), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L)));
    }

    private static void checkValidArguments(QueryDataTypeFamily orderingColumnType, String windowSize, Object[] ... values) {
        String name = SqlTumbleTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), values);
        try (SqlResult result = sqlService.execute("SELECT * FROM TABLE(TUMBLE(TABLE " + name + ", DESCRIPTOR(ts), " + windowSize + "))", new Object[0]);){
            Assertions.assertThat((int)result.getRowMetadata().findColumn("window_start")).isEqualTo(1);
            Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(1).getType()).isEqualTo((Object)orderingColumnType.getPublicType());
            Assertions.assertThat((int)result.getRowMetadata().findColumn("window_end")).isEqualTo(2);
            Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(2).getType()).isEqualTo((Object)orderingColumnType.getPublicType());
            Assertions.assertThat((Iterator)result.iterator()).hasNext();
        }
    }

    @Test
    public void test_invalidArguments_tinyInt() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.TINYINT, "INTERVAL '0.001' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_smallInt() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.SMALLINT, "INTERVAL '0.002' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_int() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.INTEGER, "INTERVAL '0.003' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_bigInt() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.BIGINT, "INTERVAL '0.004' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_decimal_interval() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.DECIMAL, "INTERVAL '0.005' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_decimal_number() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.DECIMAL, "6", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_real_interval() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.REAL, "INTERVAL '0.007' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_real_number() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.REAL, "8", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_double_interval() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.DOUBLE, "INTERVAL '0.009' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND);
    }

    @Test
    public void test_invalidArguments_double_number() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.DOUBLE, "10", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_time() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.TIME, "11", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_date() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.DATE, "12", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_timestamp() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.TIMESTAMP, "13", QueryDataTypeFamily.TINYINT);
    }

    @Test
    public void test_invalidArguments_timestampTz() {
        SqlTumbleTest.checkInvalidArguments(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "14", QueryDataTypeFamily.TINYINT);
    }

    private static void checkInvalidArguments(QueryDataTypeFamily orderingColumnType, String windowSize, QueryDataTypeFamily windowSizeType) {
        String name = SqlTumbleTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(TUMBLE(TABLE " + name + ", DESCRIPTOR(ts), " + windowSize + "))", new Object[0])).hasMessageContaining("The descriptor column type (" + String.valueOf(orderingColumnType) + ") and the interval type (" + String.valueOf(windowSizeType) + ") do not match");
    }

    @Test
    public void test_windowBounds() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Alice", 1));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, name FROM TABLE(TUMBLE(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND))", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), "Alice"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), SqlTumbleTest.timestampTz(6L), "Alice")));
    }

    @Test
    public void test_filterWindowBounds() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(1000L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2000L), null, null));
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM TABLE(TUMBLE(    (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '1' SECOND))),    DESCRIPTOR(ts), INTERVAL '1' SECOND)) WHERE window_start != window_end GROUP BY window_start", new Object[0])).hasMessageEndingWith("Can't apply filter criteria to window bounds");
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT 1 FROM TABLE(TUMBLE(    (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '1' SECOND))),    DESCRIPTOR(ts), INTERVAL '1' SECOND)) WHERE EXTRACT(DAY FROM window_start) != EXTRACT(DAY FROM window_end) GROUP BY window_start", new Object[0])).hasMessageEndingWith("Can't apply filter criteria to window bounds");
    }

    @Test
    public void test_groupBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY 1, 2", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), SqlTumbleTest.timestampTz(4L)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), SqlTumbleTest.timestampTz(6L))));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, name FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.003' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.003' SECOND)) GROUP BY window_end, window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(3L), "Alice"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(3L), null), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L), SqlTumbleTest.timestampTz(6L), "Bob"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L), SqlTumbleTest.timestampTz(6L), "Alice")));
    }

    @Test
    public void test_groupByNotSelectedField() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L))));
    }

    @Test
    public void test_groupByExpression() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name || '-s' AS n FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start, n", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice-s"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob-s"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice-s")));
    }

    @Test
    public void test_groupByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(7L), "Alice", 1));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name || '-s' AS n FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start, name HAVING LENGTH(n) > 5", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice-s"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice-s")));
    }

    @Test
    public void test_groupByEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_count() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 2L)));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(*) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 2L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_countDistinct() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(DISTINCT name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_countWithUnionAsInput() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        sqlService.execute("CREATE VIEW v1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND))", new Object[0]);
        sqlService.execute("CREATE VIEW v2 AS (SELECT * FROM v1) UNION ALL (SELECT * FROM v1)", new Object[0]);
        SqlTumbleTest.assertTipOfStream("SELECT window_start, COUNT(name) FROM TABLE(TUMBLE(TABLE v2, DESCRIPTOR(ts), INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 2L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 4L)));
    }

    @Test
    public void test_countGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 3L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_countDistinctGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(DISTINCT distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 2L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_countGroupedByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(*) c FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING c <> 2", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", 3L)));
    }

    @Test
    public void test_countFilter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, COUNT(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", 2L)));
    }

    @Test
    public void test_countEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start, COUNT(*) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_min() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Joey", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MIN(name), MIN(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 1), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 2)));
    }

    @Test
    public void test_minDistinct() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MIN(DISTINCT name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob")));
    }

    @Test
    public void test_minGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 1), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 1)));
    }

    @Test
    public void test_minGroupedByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 4), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) m FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING m > 1", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Alice", 3)));
    }

    @Test
    public void test_minFilter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MIN(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "' GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 1), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 3)));
    }

    @Test
    public void test_minEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start, MIN(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_max() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Joey", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MAX(name), MAX(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Joey", 3)));
    }

    @Test
    public void test_maxDistinct() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, MAX(DISTINCT name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob"), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Joey")));
    }

    @Test
    public void test_maxGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 1), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 2)));
    }

    @Test
    public void test_maxGroupedByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Alice", 0), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) m FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING m < 3", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Alice", 1)));
    }

    @Test
    public void test_maxFilter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, MAX(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "' GROUP BY window_start, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 2), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 3)));
    }

    @Test
    public void test_maxEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start, MAX(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_sum() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, SUM(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 2L)));
    }

    @Test
    public void test_sumDistinct() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, SUM(DISTINCT distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 3L)));
    }

    @Test
    public void test_sumGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 4L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 3L)));
    }

    @Test
    public void test_sumDistinctGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(DISTINCT distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", 3L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 3L)));
    }

    @Test
    public void test_sumGroupedByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) s FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING s > 1", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", 2L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", 3L)));
    }

    @Test
    public void test_sumFilter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, SUM(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", 2L)));
    }

    @Test
    public void test_sumEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start, SUM(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_avg() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null, null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, AVG(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), new BigDecimal(2)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), new BigDecimal(1))));
    }

    @Test
    public void test_avgDistinct() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, AVG(DISTINCT distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), new BigDecimal("1.5"))));
    }

    @Test
    public void test_avgGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 4), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", new BigDecimal(2)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", new BigDecimal("1.5"))));
    }

    @Test
    public void test_avgDistinctGroupedBy() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 2), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(DISTINCT distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Alice", new BigDecimal("1.5")), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", new BigDecimal("1.5"))));
    }

    @Test
    public void test_avgGroupedByHaving() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 4), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) a FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY name, window_start HAVING a > 1", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Bob", new BigDecimal(2)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", new BigDecimal(2))));
    }

    @Test
    public void test_avgFilter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, name, AVG(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "' GROUP BY name, window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), "Bob", new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), "Alice", new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), "Joey", new BigDecimal(2))));
    }

    @Test
    public void test_avgEmpty() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        SqlTumbleTest.assertEmptyResultStream("SELECT window_start, AVG(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start");
    }

    @Test
    public void test_multipleAggregations() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Bob", 3), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, COUNT(*), MIN(name), MAX(name), SUM(distance), AVG(distance) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), 2L, "Alice", "Bob", 2L, new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), 1L, "Alice", "Alice", 1L, new BigDecimal(1)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), 2L, "Bob", "Joey", 4L, new BigDecimal(2))));
    }

    @Test
    public void test_ordering_tinyInt() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.TINYINT, "2", SqlTumbleTest.row((byte)0), SqlTumbleTest.row((byte)4));
    }

    @Test
    public void test_ordering_smallInt() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.SMALLINT, "2", SqlTumbleTest.row((short)0), SqlTumbleTest.row((short)4));
    }

    @Test
    public void test_ordering_int() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.INTEGER, "2", SqlTumbleTest.row(0), SqlTumbleTest.row(4));
    }

    @Test
    public void test_ordering_bigInt() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.BIGINT, "2", SqlTumbleTest.row(0L), SqlTumbleTest.row(4L));
    }

    @Test
    public void test_ordering_time() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.TIME, "INTERVAL '0.002' SECOND", SqlTumbleTest.row(SqlTumbleTest.time(0L)), SqlTumbleTest.row(SqlTumbleTest.time(4L)));
    }

    @Test
    public void test_ordering_date() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.DATE, "INTERVAL '2' DAYS", SqlTumbleTest.row(SqlTumbleTest.date(0L)), SqlTumbleTest.row(SqlTumbleTest.date(345600000L)));
    }

    @Test
    public void test_ordering_timestamp() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.TIMESTAMP, "INTERVAL '0.002' SECOND", SqlTumbleTest.row(SqlTumbleTest.timestamp(0L)), SqlTumbleTest.row(SqlTumbleTest.timestamp(4L)));
    }

    @Test
    public void test_ordering_timestampTz() {
        SqlTumbleTest.checkOrdering(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "INTERVAL '0.002' SECOND", SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L)), SqlTumbleTest.row(SqlTumbleTest.timestampTz(4L)));
    }

    private static void checkOrdering(QueryDataTypeFamily orderingColumnType, String windowSize, Object[] ... values) {
        String name = SqlTumbleTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), values);
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT COUNT(*) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), " + windowSize + ")))  , DESCRIPTOR(ts)  , " + windowSize + ")) GROUP BY window_start", Collections.singletonList(new SqlTestSupport.Row(1L)));
    }

    @Test
    public void test_nested_filter() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_start_inner, name, COUNT(name) FROM TABLE(TUMBLE(   (SELECT ts, name, window_start window_start_inner FROM      TABLE(TUMBLE(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND       )) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "'    )   , DESCRIPTOR(ts)   , INTERVAL '0.003' SECOND)) GROUP BY window_start, window_start_inner, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(0L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L), SqlTumbleTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_nested_project() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_start_inner_1, name, COUNT(name) FROM TABLE(TUMBLE(   (SELECT ts, name, window_start window_start_inner_1, window_start window_start_inner_2 FROM      TABLE(TUMBLE(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND       ))   )   , DESCRIPTOR(ts)   , INTERVAL '0.003' SECOND)) GROUP BY window_start, window_start_inner_1, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(0L), "Alice", 2L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L), SqlTumbleTest.timestampTz(2L), "Bob", 1L)));
    }

    @Test
    public void test_nested_aggregate() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(5L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_end, window_end_inner, name, COUNT(name) FROM TABLE(TUMBLE(   (SELECT name, window_end AS window_end_inner FROM        TABLE(TUMBLE(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.001' SECOND       )) GROUP BY name, window_end_inner   )   , DESCRIPTOR(window_end_inner)   , INTERVAL '0.002' SECOND)) GROUP BY window_end, window_end_inner, name", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), SqlTumbleTest.timestampTz(1L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), SqlTumbleTest.timestampTz(2L), "Bob", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(4L), SqlTumbleTest.timestampTz(3L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(6L), SqlTumbleTest.timestampTz(4L), "Alice", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(8L), SqlTumbleTest.timestampTz(6L), "Bob", 1L)));
    }

    @Test
    public void test_nested_join() {
        SqlTumbleTest.createMapping("map", OffsetDateTime.class, String.class);
        SqlTumbleTest.instance().getMap("map").put((Object)SqlTumbleTest.timestampTz(0L), (Object)"value-0");
        SqlTumbleTest.instance().getMap("map").put((Object)SqlTumbleTest.timestampTz(1L), (Object)"value-1");
        SqlTumbleTest.instance().getMap("map").put((Object)SqlTumbleTest.timestampTz(2L), (Object)"value-1");
        SqlTumbleTest.instance().getMap("map").put((Object)SqlTumbleTest.timestampTz(3L), (Object)"value-1");
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Joey", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_start_inner, this, COUNT(*) FROM TABLE(TUMBLE(   (SELECT ts, window_start window_start_inner, this FROM        TABLE(TUMBLE(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND       )) JOIN map ON ts = __key   )   , DESCRIPTOR(ts)   , INTERVAL '0.003' SECOND)) GROUP BY window_start, window_start_inner, this", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(0L), "value-0", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(0L), "value-1", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), "value-1", 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L), SqlTumbleTest.timestampTz(2L), "value-1", 1L)));
    }

    @Test
    public void test_groupingOnWatermarkedColumnThatIsNotAWindowBound() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start_inner, name, COUNT(name) FROM TABLE(TUMBLE(   (SELECT ts, name, window_start window_start_inner FROM      TABLE(TUMBLE(           (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))           , DESCRIPTOR(ts)           , INTERVAL '0.002' SECOND       )) WHERE ts > '" + String.valueOf(SqlTumbleTest.timestampTz(0L)) + "'    )   , DESCRIPTOR(ts)   , INTERVAL '0.003' SECOND)) GROUP BY window_start_inner, name", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_namedParameters() {
        String name = SqlTumbleTest.createTable(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob", 1), SqlTumbleTest.row(SqlTumbleTest.timestampTz(10L), null, null));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, COUNT(name) FROM TABLE(TUMBLE(   window_size => INTERVAL '0.002' SECOND   , time_col => DESCRIPTOR(ts)   , input => (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND))))) GROUP BY window_start, window_end", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), SqlTumbleTest.timestampTz(4L), 2L)));
    }

    @Test
    public void test_groupByWithoutOrdering() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start FROM TABLE(TUMBLE(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)) GROUP BY window_start", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_aggregationWithoutOrdering() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(TUMBLE(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND)) GROUP BY window_start", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_aggregationWithoutOrderingAndGrouping() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(TUMBLE(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_noGroupBy() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_groupByNonWindowBoundWithExpression() {
        String name = SqlTumbleTest.createTable(new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT window_start + INTERVAL '0.001' SECOND, COUNT(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start + INTERVAL '0.001' SECOND", new Object[0])).hasRootCauseMessage("In window aggregation, the window_start and window_end fields must be used directly, without any transformation");
    }

    @Test
    public void test_batchSource() {
        String name = SqlTumbleTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), TestBatchSqlConnector.valuesToString(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob")));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start, window_end, COUNT(name) FROM TABLE(TUMBLE(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start, window_end", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(0L), SqlTumbleTest.timestampTz(2L), 1L), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(2L), SqlTumbleTest.timestampTz(4L), 2L)));
    }

    @Test
    public void test_batchSource_noGroupBy() {
        String name = SqlTumbleTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), TestBatchSqlConnector.valuesToString(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob")));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT COUNT(name) FROM TABLE(TUMBLE(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND))", Collections.singletonList(new SqlTestSupport.Row(3L)));
    }

    @Test
    public void test_batchSource_groupByNonWindowBound() {
        String name = SqlTumbleTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), TestBatchSqlConnector.valuesToString(SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(1L), null), SqlTumbleTest.row(SqlTumbleTest.timestampTz(2L), "Alice"), SqlTumbleTest.row(SqlTumbleTest.timestampTz(3L), "Bob")));
        SqlTumbleTest.assertRowsEventuallyInAnyOrder("SELECT window_start + INTERVAL '0.001' SECOND FROM TABLE(TUMBLE(  TABLE " + name + "  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND)) GROUP BY window_start + INTERVAL '0.001' SECOND", Arrays.asList(new SqlTestSupport.Row(SqlTumbleTest.timestampTz(1L)), new SqlTestSupport.Row(SqlTumbleTest.timestampTz(3L))));
    }

    @Test
    public void test_emptyGroup() {
        String name = SqlTumbleTest.createTable(new Object[][]{SqlTumbleTest.row(SqlTumbleTest.timestampTz(0L), "Alice", 1)});
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(name) FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)))  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    private static String createTable(Object[] ... values) {
        String name = SqlTumbleTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Arrays.asList("ts", "name", "distance"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), values);
        return name;
    }
}

