/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class STSJoinSlidingWindowAggregationTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        STSJoinSlidingWindowAggregationTest.initialize((int)1, null);
    }

    @Test
    public void test() {
        String stream1 = "stream_a";
        TestStreamSqlConnector.create(STSJoinSlidingWindowAggregationTest.instance().getSql(), stream1, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE), STSJoinSlidingWindowAggregationTest.row(1, STSJoinSlidingWindowAggregationTest.timestampTz(1L)), STSJoinSlidingWindowAggregationTest.row(3, STSJoinSlidingWindowAggregationTest.timestampTz(3L)), STSJoinSlidingWindowAggregationTest.row(5, STSJoinSlidingWindowAggregationTest.timestampTz(5L)), STSJoinSlidingWindowAggregationTest.row(7, STSJoinSlidingWindowAggregationTest.timestampTz(7L)), STSJoinSlidingWindowAggregationTest.row(41, STSJoinSlidingWindowAggregationTest.timestampTz(41L)));
        String stream2 = "stream_b";
        TestStreamSqlConnector.create(STSJoinSlidingWindowAggregationTest.instance().getSql(), stream2, Arrays.asList("c", "d"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), STSJoinSlidingWindowAggregationTest.row(STSJoinSlidingWindowAggregationTest.timestampTz(0L), 0), STSJoinSlidingWindowAggregationTest.row(STSJoinSlidingWindowAggregationTest.timestampTz(2L), 2), STSJoinSlidingWindowAggregationTest.row(STSJoinSlidingWindowAggregationTest.timestampTz(4L), 4), STSJoinSlidingWindowAggregationTest.row(STSJoinSlidingWindowAggregationTest.timestampTz(6L), 6), STSJoinSlidingWindowAggregationTest.row(STSJoinSlidingWindowAggregationTest.timestampTz(41L), 41));
        STSJoinSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s1 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_a, DESCRIPTOR(b), INTERVAL '0.003' SECOND))", new Object[0]);
        STSJoinSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s_agg1 AS  SELECT window_end AS we1, SUM(a) AS max2 FROM  TABLE(TUMBLE(TABLE s1, DESCRIPTOR(b), INTERVAL '0.003' SECOND)) GROUP BY window_end", new Object[0]);
        STSJoinSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s2 AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream_b, DESCRIPTOR(c), INTERVAL '0.003' SECOND))", new Object[0]);
        STSJoinSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW s_agg2 AS  SELECT window_end AS we2, MAX(d) AS max2 FROM  TABLE(TUMBLE(TABLE s2, DESCRIPTOR(c), INTERVAL '0.003' SECOND)) GROUP BY window_end", new Object[0]);
        STSJoinSlidingWindowAggregationTest.instance().getSql().executeUpdate("CREATE VIEW joined_aggregated_streams AS SELECT * FROM s_agg1 JOIN s_agg2 ON s_agg1.we1 = s_agg2.we2", new Object[0]);
        String sql = " SELECT window_start AS ws, COUNT(max2) AS cnt FROM  TABLE(TUMBLE(TABLE joined_aggregated_streams, DESCRIPTOR(we1), INTERVAL '0.003' SECOND))  GROUP BY window_start";
        STSJoinSlidingWindowAggregationTest.assertRowsEventuallyInAnyOrder(sql, Arrays.asList(new SqlTestSupport.Row(STSJoinSlidingWindowAggregationTest.timestampTz(3L), 1L), new SqlTestSupport.Row(STSJoinSlidingWindowAggregationTest.timestampTz(6L), 1L), new SqlTestSupport.Row(STSJoinSlidingWindowAggregationTest.timestampTz(9L), 1L)));
    }
}

