/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.aggregate.MaxSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class MaxSqlAggregationTest {
    @Test
    public void test_default() {
        MaxSqlAggregation aggregation = new MaxSqlAggregation();
        Assertions.assertThat((Object)aggregation.collect()).isNull();
    }

    private Object[] values() {
        return new Object[]{new Object[]{null, null, null}, new Object[]{null, 1, 1}, new Object[]{1, null, 1}, new Object[]{1, 1, 1}, new Object[]{1, 2, 2}, new Object[]{2, 1, 2}};
    }

    @Test
    @Parameters(method="values")
    public void test_accumulate(Object value1, Object value2, Object expected) {
        MaxSqlAggregation aggregation = new MaxSqlAggregation();
        aggregation.accumulate(value1);
        aggregation.accumulate(value2);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo(expected);
    }

    @Test
    @Parameters(method="values")
    public void test_combine(Object value1, Object value2, Object expected) {
        MaxSqlAggregation left = new MaxSqlAggregation();
        left.accumulate(value1);
        MaxSqlAggregation right = new MaxSqlAggregation();
        right.accumulate(value2);
        left.combine((SqlAggregation)right);
        Assertions.assertThat((Object)left.collect()).isEqualTo(expected);
        Assertions.assertThat((Object)right.collect()).isEqualTo(value2);
    }

    @Test
    public void test_serialization() {
        MaxSqlAggregation original = new MaxSqlAggregation();
        original.accumulate((Object)1);
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        MaxSqlAggregation serialized = (MaxSqlAggregation)ss.toObject((Object)ss.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

