/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.aggregate.CountSqlAggregations;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CountSqlAggregationTest {
    @Test
    public void test_default() {
        SqlAggregation aggregation = CountSqlAggregations.from((boolean)false, (boolean)false);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)0L);
    }

    @Test
    public void test_accumulate() {
        SqlAggregation aggregation = CountSqlAggregations.from((boolean)false, (boolean)false);
        aggregation.accumulate(null);
        aggregation.accumulate((Object)1);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)2L);
    }

    @Test
    public void test_accumulateIgnoreNulls() {
        SqlAggregation aggregation = CountSqlAggregations.from((boolean)true, (boolean)false);
        aggregation.accumulate(null);
        aggregation.accumulate((Object)1);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)1L);
    }

    @Test
    public void test_accumulateDistinct() {
        SqlAggregation aggregation = CountSqlAggregations.from((boolean)false, (boolean)true);
        aggregation.accumulate(null);
        aggregation.accumulate((Object)1);
        aggregation.accumulate((Object)1);
        aggregation.accumulate((Object)2);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)3L);
    }

    @Test
    public void test_accumulateIgnoreNullsAndDistinct() {
        SqlAggregation aggregation = CountSqlAggregations.from((boolean)true, (boolean)true);
        aggregation.accumulate(null);
        aggregation.accumulate((Object)1);
        aggregation.accumulate((Object)1);
        aggregation.accumulate((Object)2);
        Assertions.assertThat((Object)aggregation.collect()).isEqualTo((Object)2L);
    }

    @Test
    public void test_combine() {
        SqlAggregation left = CountSqlAggregations.from((boolean)false, (boolean)false);
        left.accumulate(null);
        SqlAggregation right = CountSqlAggregations.from((boolean)false, (boolean)false);
        right.accumulate(null);
        left.combine(right);
        Assertions.assertThat((Object)left.collect()).isEqualTo((Object)2L);
        Assertions.assertThat((Object)right.collect()).isEqualTo((Object)1L);
    }

    @Test
    public void test_serialization() {
        SqlAggregation original = CountSqlAggregations.from((boolean)false, (boolean)false);
        original.accumulate(null);
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        SqlAggregation serialized = (SqlAggregation)ss.toObject((Object)ss.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }
}

