/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.SqlConfig;
import com.hazelcast.jet.sql.SqlTestSupport;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class UntimedStatementTest
extends SqlTestSupport {
    @BeforeClass
    public static void before() {
        SqlConfig globalStatementTimeoutConfig = new SqlConfig().setStatementTimeoutMillis(1000L);
        UntimedStatementTest.initializeWithClient((int)1, (Config)UntimedStatementTest.smallInstanceConfig().setSqlConfig(globalStatementTimeoutConfig), null);
    }

    @Test
    public void testTimeoutIgnoredForCreateMapping() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("CREATE OR REPLACE MAPPING myMap\nTYPE IMap\nOPTIONS (\n    'keyFormat'='varchar',\n    'valueFormat'='int');\n", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForDropMapping() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("DROP MAPPING IF EXISTS myMap", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForCreateDataConnection() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("CREATE DATA CONNECTION IF NOT EXISTS myKafkaSource\nTYPE Kafka\nSHARED\nOPTIONS (\n    'bootstrap.servers' = '127.0.0.1:9092');\n", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForDropDataConnection() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("DROP DATA CONNECTION IF EXISTS data_connection_name", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForCreateIndex() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            UntimedStatementTest.client().getSql().execute("CREATE OR REPLACE MAPPING myMap (\n    name varchar,\n    id INT\n)\nTYPE IMap\nOPTIONS (\n    'keyFormat'='varchar',\n    'valueFormat'='json-flat');\n", new Object[0]).close();
            UntimedStatementTest.client().getSql().execute("CREATE INDEX IF NOT EXISTS id\nON myMap (id)\nTYPE SORTED;\n", new Object[0]).close();
        });
    }

    @Test
    public void testTimeoutIgnoredForCreateJob() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            UntimedStatementTest.client().getSql().execute("CREATE OR REPLACE MAPPING myMap (\n    name varchar,\n    id INT\n)\nTYPE IMap\nOPTIONS (\n    'keyFormat'='varchar',\n    'valueFormat'='json-flat');\n", new Object[0]).close();
            UntimedStatementTest.client().getSql().execute("CREATE JOB myJob\nAS\nINSERT INTO myMap\nSELECT * FROM myMap;\n", new Object[0]).close();
        });
    }

    @Test
    public void testTimeoutIgnoredForDropJob() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("DROP JOB IF EXISTS test_job", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForCreateView() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            UntimedStatementTest.client().getSql().execute("CREATE OR REPLACE MAPPING myMap (\n    name varchar,\n    id INT\n)\nTYPE IMap\nOPTIONS (\n    'keyFormat'='varchar',\n    'valueFormat'='json-flat');\n", new Object[0]).close();
            UntimedStatementTest.client().getSql().execute("CREATE VIEW testView\nAS\nSELECT *\nFROM myMap\nWHERE id > 70;\n", new Object[0]).close();
        });
    }

    @Test
    public void testTimeoutIgnoredForDropView() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("DROP VIEW IF EXISTS testView", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForShow() {
        Assertions.assertThatNoException().isThrownBy(() -> UntimedStatementTest.client().getSql().execute("SHOW MAPPINGS", new Object[0]).close());
    }

    @Test
    public void testTimeoutIgnoredForExplain() {
        Assertions.assertThatNoException().isThrownBy(() -> {
            UntimedStatementTest.client().getSql().execute("CREATE OR REPLACE MAPPING myMap\nTYPE IMap\nOPTIONS (\n    'keyFormat'='varchar',\n    'valueFormat'='int');\n", new Object[0]).close();
            UntimedStatementTest.client().getSql().execute("EXPLAIN SELECT * FROM myMap", new Object[0]).close();
        });
    }
}

