/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlResultImplTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        SqlResultImplTest.initialize((int)1, null);
    }

    @Test
    public void when_closed_then_iteratorFails() {
        SqlResult sqlResult = SqlResultImplTest.instance().getSql().execute("select * from table(generate_stream(1))", new Object[0]);
        sqlResult.close();
        Iterator iterator = sqlResult.iterator();
        Assertions.assertThatThrownBy(() -> iterator.forEachRemaining(ConsumerEx.noop()));
    }

    @Test
    public void when_hasNextInterrupted_then_interrupted() {
        SqlResult sqlResult = SqlResultImplTest.instance().getSql().execute("select * from table(generate_stream(1)) where v < 0", new Object[0]);
        AtomicBoolean interruptedOk = new AtomicBoolean();
        Thread t = new Thread(() -> {
            try {
                sqlResult.iterator().hasNext();
            }
            catch (Throwable e) {
                if (e.getCause() instanceof RuntimeException && e.getCause().getCause() instanceof InterruptedException) {
                    interruptedOk.set(true);
                }
                this.logger.severe("Unexpected exception caught", e);
            }
        });
        t.start();
        t.interrupt();
        SqlResultImplTest.assertTrueEventually(() -> Assert.assertTrue((boolean)interruptedOk.get()));
    }
}

