/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class SqlImposeOrderFunctionTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() throws IOException {
        SqlImposeOrderFunctionTest.initialize((int)1, null);
        sqlService = SqlImposeOrderFunctionTest.instance().getSql();
    }

    private Object[] validArguments() {
        return new Object[]{new Object[]{QueryDataTypeFamily.TINYINT, "1", SqlImposeOrderFunctionTest.row((byte)0), SqlImposeOrderFunctionTest.row((byte)2)}, new Object[]{QueryDataTypeFamily.SMALLINT, "2", SqlImposeOrderFunctionTest.row((short)0), SqlImposeOrderFunctionTest.row((short)2)}, new Object[]{QueryDataTypeFamily.INTEGER, "3", SqlImposeOrderFunctionTest.row(0), SqlImposeOrderFunctionTest.row(2)}, new Object[]{QueryDataTypeFamily.BIGINT, "4", SqlImposeOrderFunctionTest.row(0L), SqlImposeOrderFunctionTest.row(2L)}, new Object[]{QueryDataTypeFamily.TIME, "INTERVAL '0.005' SECOND", SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.time(0L)), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.time(2L))}, new Object[]{QueryDataTypeFamily.DATE, "INTERVAL '0.006' SECOND", SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.date(0L)), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.date(2L))}, new Object[]{QueryDataTypeFamily.TIMESTAMP, "INTERVAL '0.007' SECOND", SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestamp(0L)), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestamp(2L))}, new Object[]{QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "INTERVAL '0.008' SECOND", SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(0L)), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(2L))}};
    }

    @Test
    @Parameters(method="validArguments")
    public void test_validArguments(QueryDataTypeFamily orderingColumnType, String maxLag, Object[] ... values) {
        String name = SqlImposeOrderFunctionTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), values);
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), " + maxLag + "))", Arrays.stream(values).map(SqlTestSupport.Row::new).collect(Collectors.toList()));
    }

    private Object[] invalidArguments() {
        return new Object[]{new Object[]{QueryDataTypeFamily.TINYINT, "INTERVAL '0.001' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.SMALLINT, "INTERVAL '0.002' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.INTEGER, "INTERVAL '0.003' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.BIGINT, "INTERVAL '0.004' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.DECIMAL, "INTERVAL '0.005' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.DECIMAL, "6", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.REAL, "INTERVAL '0.007' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.REAL, "8", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.DOUBLE, "INTERVAL '0.009' SECOND", QueryDataTypeFamily.INTERVAL_DAY_SECOND}, new Object[]{QueryDataTypeFamily.DOUBLE, "10", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.TIME, "11", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.DATE, "12", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.TIMESTAMP, "13", QueryDataTypeFamily.TINYINT}, new Object[]{QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, "14", QueryDataTypeFamily.TINYINT}};
    }

    @Test
    @Parameters(method="invalidArguments")
    public void test_invalidArguments(QueryDataTypeFamily orderingColumnType, String maxLag, QueryDataTypeFamily lagType) {
        String name = SqlImposeOrderFunctionTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("ts"), Collections.singletonList(orderingColumnType), new Object[0][]);
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), " + maxLag + "))", new Object[0])).hasMessageContaining("The descriptor column type (" + String.valueOf(orderingColumnType) + ") and the interval type (" + String.valueOf(lagType) + ") do not match");
    }

    @Test
    public void test_nestedInvocations() {
        String name = SqlImposeOrderFunctionTest.createTable(new Object[0][]);
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(IMPOSE_ORDER(  (SELECT * FROM    TABLE(IMPOSE_ORDER(      TABLE " + name + "      , DESCRIPTOR(ts)      , INTERVAL '0.001' SECOND    ))  )  , DESCRIPTOR(ts)  , INTERVAL '0.002' SECOND))", new Object[0])).hasMessageContaining("IMPOSE_ORDER call is not supported in this configuration");
    }

    @Test
    public void test_imposeOrderCannotBePushedToScan() {
        SqlImposeOrderFunctionTest.createMapping("m", Integer.class, OffsetDateTime.class);
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE m, DESCRIPTOR(this), INTERVAL '0' SECONDS))", new Object[0])).hasMessageContaining("Ordering functions are not supported on top of IMap mappings");
    }

    @Test
    public void test_singleColumn() {
        String name = SqlImposeOrderFunctionTest.createTable(new Object[0][]);
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(), INTERVAL '0.001' SECOND))", new Object[0])).hasMessageContaining("You must specify single ordering column");
        AssertionsForClassTypes.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts, ts), INTERVAL '0.001' SECOND))", new Object[0])).hasMessageContaining("You must specify single ordering column");
    }

    @Test
    public void test_filteredInput() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(0L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(1L), null), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(  (SELECT * FROM " + name + " WHERE name != 'Alice')  , DESCRIPTOR(ts)  , INTERVAL '0.001' SECOND))", Collections.singletonList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob")));
    }

    @Test
    public void test_projectedInput() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(0L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(1L), null), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(  (SELECT ts FROM " + name + ")  , DESCRIPTOR(ts)  , INTERVAL '0.001' SECOND))", Arrays.asList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(0L)), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(1L)), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(2L))));
    }

    @Test
    public void test_filteredAndProjectedInput() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(0L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(1L), null), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(  (SELECT ts FROM " + name + " WHERE name != 'Alice')  , DESCRIPTOR(ts)  , INTERVAL '0.001' SECOND))", Collections.singletonList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(2L))));
    }

    @Test
    public void test_namedParameters() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(0L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(1L), null), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(  \"lag\" => INTERVAL '0.001' SECOND  , input => (TABLE " + name + ")  , time_col => DESCRIPTOR(ts)))", Arrays.asList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(0L), "Alice"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(1L), null), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(2L), "Bob")));
    }

    @Test
    public void test_lateItemsDropping() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(270L), "Bob"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(29L), "Zedd"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECONDS))", Arrays.asList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(270L), "Bob"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah")));
    }

    @Test
    public void test_lateItemsDidNotDropWithAllowedLag() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(290L), "Bob"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(280L), "Zedd"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.05' SECONDS))", Arrays.asList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(290L), "Bob"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(280L), "Zedd")));
    }

    @Test
    public void test_lateItemsDropWithAllowedLag() {
        String name = SqlImposeOrderFunctionTest.createTable(SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(290L), "Bob"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah"), SqlImposeOrderFunctionTest.row(SqlImposeOrderFunctionTest.timestampTz(150L), "Zedd"));
        SqlImposeOrderFunctionTest.assertRowsEventuallyInAnyOrder("SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.005' SECONDS))", Arrays.asList(new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(280L), "Alice"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(290L), "Bob"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Caitlyn"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(300L), "Dorian"), new SqlTestSupport.Row(SqlImposeOrderFunctionTest.timestampTz(310L), "Elijah")));
    }

    private static String createTable(Object[] ... values) {
        String name = SqlImposeOrderFunctionTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), values);
        return name;
    }
}

