/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.TestProcessors;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ShowStatementTest
extends SqlTestSupport {
    private static final String DATA_CONNECTION_NAME = "test-data-connection";
    private final SqlService sqlService = ShowStatementTest.instance().getSql();

    @BeforeClass
    public static void beforeClass() {
        Config config = ShowStatementTest.smallInstanceConfig();
        config.getDataConnectionConfigs().put(DATA_CONNECTION_NAME, new DataConnectionConfig().setName(DATA_CONNECTION_NAME).setType("dummy"));
        ShowStatementTest.initialize((int)2, (Config)config);
    }

    @Test
    public void test_showStatement_metadata() {
        SqlRowMetadata expectedMetadata = new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR, false)));
        Assertions.assertThat((Object)this.sqlService.execute("show mappings", new Object[0]).getRowMetadata()).isEqualTo((Object)expectedMetadata);
        Assertions.assertThat((Object)this.sqlService.execute("show jobs", new Object[0]).getRowMetadata()).isEqualTo((Object)expectedMetadata);
    }

    @Test
    public void when_showMapping_empty() {
        ShowStatementTest.assertRowsOrdered("show mappings", Collections.emptyList());
    }

    @Test
    public void test_showMapping() {
        List mappingNames = IntStream.range(0, 5).mapToObj(i -> "t" + i).collect(Collectors.toList());
        for (String mappingName : mappingNames) {
            TestBatchSqlConnector.create(this.sqlService, mappingName, 1);
        }
        ShowStatementTest.assertRowsOrdered("show mappings", Util.toList(mappingNames, xva$0 -> new SqlTestSupport.Row(xva$0)));
    }

    @Test
    public void test_withOptionalExternalKeyword() {
        TestBatchSqlConnector.create(this.sqlService, "t", 1);
        ShowStatementTest.assertRowsOrdered("show external mappings", Collections.singletonList(new SqlTestSupport.Row("t")));
    }

    @Test
    public void when_implicitMapping_then_notVisible() {
        IMap myMap = ShowStatementTest.instance().getMap("my_map");
        for (int i = 0; i < 10; ++i) {
            myMap.put((Object)i, (Object)i);
        }
        ShowStatementTest.assertRowsOrdered("show mappings", Collections.emptyList());
    }

    @Test
    public void when_showViews_empty() {
        ShowStatementTest.assertRowsOrdered("show views", Collections.emptyList());
    }

    @Test
    public void test_showViews() {
        List viewNames = IntStream.range(0, 5).mapToObj(i -> "v" + i).collect(Collectors.toList());
        for (String viewName : viewNames) {
            this.sqlService.execute("create view " + viewName + " AS SELECT 1", new Object[0]);
        }
        ShowStatementTest.assertRowsOrdered("show views", Util.toList(viewNames, xva$0 -> new SqlTestSupport.Row(xva$0)));
    }

    @Test
    public void test_showJobsEmpty() {
        ShowStatementTest.assertRowsOrdered("show jobs", Collections.emptyList());
    }

    @Test
    public void test_showJobs() {
        ShowStatementTest.createMapping("m", Integer.class, Integer.class);
        this.sqlService.execute("create job testJob as sink into m select v, v from table(generate_stream(1))", new Object[0]);
        ShowStatementTest.assertRowsOrdered("show jobs", Collections.singletonList(new SqlTestSupport.Row("testJob")));
    }

    @Test
    public void when_jobCompleted_then_notShown() {
        TestBatchSqlConnector.create(this.sqlService, "t", 1);
        ShowStatementTest.createMapping("m", Integer.class, Integer.class);
        this.sqlService.execute("create job testJob as sink into m select v, v from t", new Object[0]);
        ShowStatementTest.assertTrueEventually(() -> ShowStatementTest.assertRowsOrdered("show jobs", Collections.emptyList()));
    }

    @Test
    public void when_jobSubmittedThroughJava_then_shown() {
        this.createJobInJava("testJob");
        ShowStatementTest.assertRowsOrdered("show jobs", Collections.singletonList(new SqlTestSupport.Row("testJob")));
    }

    @Test
    public void when_unnamedJob_then_notListed() {
        this.createJobInJava(null);
        ShowStatementTest.assertRowsOrdered("show jobs", Collections.emptyList());
    }

    @Test
    public void when_showMappingsWithParameters_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sqlService.execute("SHOW MAPPINGS", new Object[]{"param"})).isInstanceOf(HazelcastSqlException.class)).hasMessage("SHOW MAPPINGS does not support dynamic parameters");
    }

    @Test
    public void when_showJobsWithParameters_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sqlService.execute("SHOW JOBS", new Object[]{"param"})).isInstanceOf(HazelcastSqlException.class)).hasMessage("SHOW JOBS does not support dynamic parameters");
    }

    @Test
    public void test_showResources() {
        ShowStatementTest.assertRowsOrdered("SHOW RESOURCES FOR \"test-data-connection\"", ShowStatementTest.rows(2, "\"testName1\"", "testType1", "\"testPrefix1\".\"testName2\"", "testType2"));
    }

    @Test
    public void test_showResources_nonExistent() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sqlService.execute("SHOW RESOURCES FOR non_existent_data_connection", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Data connection 'non_existent_data_connection' not found");
    }

    @Test
    public void test_showResources_nonExistent_wrongSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sqlService.execute("SHOW RESOURCES FOR foo_schema.\"test-data-connection\"", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Data connections exist only in the 'public' schema");
    }

    private void createJobInJava(String jobName) {
        DAG dag = new DAG();
        dag.newVertex("v", (SupplierEx & Serializable)() -> new TestProcessors.MockP().streaming());
        ShowStatementTest.instance().getJet().newJob(dag, new JobConfig().setName(jobName));
    }
}

