/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.SqlEndToEndTestSupport;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MemberPruningTest
extends SqlEndToEndTestSupport {
    public static final int MEMBER_COUNT = 5;
    private static final Random RAND = new Random();
    private String key;
    private HazelcastInstance partitionOwnerMember;
    private String mapName;

    @BeforeClass
    public static void setupClass() {
        MemberPruningTest.initialize((int)5, (Config)MemberPruningTest.defaultInstanceConfigWithJetEnabled());
    }

    @Before
    public void setup() {
        this.mapName = "test_" + MemberPruningTest.randomName();
        MemberPruningTest.createMapping(this.mapName, KeyPojo.class, Integer.class);
    }

    @Test
    public void testSimpleSelect() {
        this.configureMapWithAttributes(this.mapName, "stringField");
        this.populateMap();
        MemberPruningTest.assertRowsAnyOrder(MemberPruningTest.instance(), "SELECT this FROM " + this.mapName + " WHERE stringField = ?", Collections.singletonList(this.key), Collections.singletonList(new SqlTestSupport.Row(0)));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instance(), this.partitionOwnerMember);
    }

    @Test
    public void testSimpleSelectWithNonPartitioningKey() {
        this.populateMap();
        MemberPruningTest.assertRowsAnyOrder(MemberPruningTest.instance(), "SELECT this FROM " + this.mapName + " WHERE longField = ?", Collections.singletonList(Long.MAX_VALUE), Collections.singletonList(new SqlTestSupport.Row(0)));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instances());
    }

    @Test
    public void testSelectMultiplePartitioningAttributes() {
        long longField;
        String stringField;
        Partition partition;
        this.configureMapWithAttributes(this.mapName, "stringField", "longField");
        this.partitionOwnerMember = this.getRandomMember();
        Member localMember = this.partitionOwnerMember.getCluster().getLocalMember();
        PartitionService partitionService = this.partitionOwnerMember.getPartitionService();
        do {
            stringField = MemberPruningTest.randomString();
            longField = RAND.nextLong();
        } while (!localMember.equals((partition = partitionService.getPartition((Object)new Object[]{stringField, longField})).getOwner()));
        this.key = stringField;
        MemberPruningTest.instance().getMap(this.mapName).set((Object)new KeyPojo(this.key, RAND.nextInt(), longField), (Object)Integer.MAX_VALUE);
        MemberPruningTest.assertRowsAnyOrder(MemberPruningTest.instance(), "SELECT this FROM " + this.mapName + " WHERE stringField = ? AND longField = ?", Arrays.asList(this.key, longField), Collections.singletonList(new SqlTestSupport.Row(Integer.MAX_VALUE)));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instance(), this.partitionOwnerMember);
    }

    @Test
    public void testSelectWithUnionAll() {
        this.configureMapWithAttributes(this.mapName, "stringField");
        String otherMapName = "test_other_" + MemberPruningTest.randomName();
        MemberPruningTest.createMapping(otherMapName, KeyPojo.class, Integer.class);
        this.configureMapWithAttributes(otherMapName, "stringField");
        this.populateMap();
        KeyPojo otherKey = new KeyPojo(MemberPruningTest.generateKeyOwnedBy((HazelcastInstance)this.partitionOwnerMember), RAND.nextInt(), Long.MAX_VALUE);
        MemberPruningTest.instance().getMap(otherMapName).set((Object)otherKey, (Object)Integer.MIN_VALUE);
        MemberPruningTest.assertRowsAnyOrder(MemberPruningTest.instance(), "(SELECT this FROM " + this.mapName + " WHERE stringField = ?) UNION ALL (SELECT this FROM " + otherMapName + " WHERE stringField = ?)", List.of(this.key, otherKey.getStringField()), List.of(new SqlTestSupport.Row(0), new SqlTestSupport.Row(Integer.MIN_VALUE)));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instance(), this.partitionOwnerMember);
    }

    @Test
    public void testSelectWithConjunctionAndArbitraryFilter() {
        this.configureMapWithAttributes(this.mapName, "stringField");
        this.populateMap();
        MemberPruningTest.assertRowsAnyOrder(MemberPruningTest.instance(), "SELECT this FROM " + this.mapName + " WHERE stringField = ? AND 1 = 1", Collections.singletonList(this.key), Collections.singletonList(new SqlTestSupport.Row(0)));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instance(), this.partitionOwnerMember);
    }

    @Test
    public void testSelectWithOrderBy() {
        this.configureMapWithAttributes(this.mapName, "stringField");
        this.populateMap(10);
        MemberPruningTest.assertRowsOrdered(MemberPruningTest.instance(), "SELECT this FROM " + this.mapName + " WHERE stringField = '" + this.key + "' ORDER BY this", MemberPruningTest.rows(1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        this.assertInvokedOnlyOnMembers(MemberPruningTest.instance(), this.partitionOwnerMember);
    }

    @Override
    @After
    public void teardown() {
        MemberPruningTest.instance().getMap(this.mapName).destroy();
    }

    private HazelcastInstance getRandomMember() {
        return MemberPruningTest.instances()[RAND.nextInt(5)];
    }

    private void populateMap() {
        this.populateMap(1);
    }

    private void populateMap(int entryCount) {
        this.partitionOwnerMember = this.getRandomMember();
        this.key = MemberPruningTest.generateKeyOwnedBy((HazelcastInstance)this.partitionOwnerMember);
        for (int i = 0; i < entryCount; ++i) {
            MemberPruningTest.instance().getMap(this.mapName).set((Object)new KeyPojo(this.key, RAND.nextInt(), Long.MAX_VALUE), (Object)i);
        }
    }

    public static class KeyPojo
    implements Serializable {
        private String stringField;
        private int intField;
        private long longField;

        public String toString() {
            return "KeyPojo{stringField='" + this.stringField + "', intField=" + this.intField + ", longField=" + this.longField + "}";
        }

        KeyPojo(String stringField, int intField, long longField) {
            this.stringField = stringField;
            this.intField = intField;
            this.longField = longField;
        }

        public String getStringField() {
            return this.stringField;
        }

        public void setStringField(String stringField) {
            this.stringField = stringField;
        }

        public int getIntField() {
            return this.intField;
        }

        public void setIntField(int intField) {
            this.intField = intField;
        }

        public long getLongField() {
            return this.longField;
        }

        public void setLongField(long longField) {
            this.longField = longField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPojo keyPojo = (KeyPojo)o;
            return this.getIntField() == keyPojo.getIntField() && this.getLongField() == keyPojo.getLongField() && Objects.equals(this.getStringField(), keyPojo.getStringField());
        }

        public int hashCode() {
            return Objects.hash(this.getStringField(), this.getIntField(), this.getLongField());
        }
    }
}

