/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CreateViewStatementTest
extends SqlTestSupport {
    private static final String LE = System.lineSeparator();
    private IMap<Integer, Integer> map;
    private IMap<String, Object> viewStorage;

    @BeforeClass
    public static void beforeClass() {
        CreateViewStatementTest.initialize((int)1, null);
    }

    @Before
    public void before() throws Exception {
        CreateViewStatementTest.createMapping("map", Integer.class, Integer.class);
        this.map = CreateViewStatementTest.instance().getMap("map");
        this.map.put((Object)1, (Object)10);
        this.viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
    }

    @Test
    public void when_createsView_then_succeeds() {
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
        Assertions.assertThat((Object)viewStorage.get((Object)"v")).isInstanceOf(View.class);
        Assertions.assertThat((String)((View)viewStorage.get((Object)"v")).query()).isEqualTo("SELECT \"map\".\"__key\", \"map\".\"this\"" + LE + "FROM \"hazelcast\".\"public\".\"map\" AS \"map\"");
        CreateViewStatementTest.assertRowsAnyOrder(((View)viewStorage.get((Object)"v")).query(), Collections.singletonList(new SqlTestSupport.Row(1, 10)));
    }

    @Test
    public void test_unnecessaryOrReplaceOption() {
        String sql = "CREATE OR REPLACE VIEW v AS SELECT * FROM map";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
        Assertions.assertThat((Object)viewStorage.get((Object)"v")).isInstanceOf(View.class);
        Assertions.assertThat((String)((View)viewStorage.get((Object)"v")).query()).isEqualTo("SELECT \"map\".\"__key\", \"map\".\"this\"" + LE + "FROM \"hazelcast\".\"public\".\"map\" AS \"map\"");
        CreateViewStatementTest.assertRowsAnyOrder(((View)viewStorage.get((Object)"v")).query(), Collections.singletonList(new SqlTestSupport.Row(1, 10)));
    }

    @Test
    public void when_createsViewWithReplace_then_succeeds() {
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((Object)viewStorage.get((Object)"v")).isInstanceOf(View.class);
        Assertions.assertThat((String)((View)viewStorage.get((Object)"v")).query()).isEqualTo("SELECT \"map\".\"__key\", \"map\".\"this\"" + LE + "FROM \"hazelcast\".\"public\".\"map\" AS \"map\"");
        CreateViewStatementTest.createMapping("map2", Integer.class, Integer.class);
        sql = "CREATE OR REPLACE VIEW v AS SELECT * FROM map2";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        Assertions.assertThat((Object)viewStorage.get((Object)"v")).isInstanceOf(View.class);
        Assertions.assertThat((String)((View)viewStorage.get((Object)"v")).query()).isEqualTo("SELECT \"map2\".\"__key\", \"map2\".\"this\"" + LE + "FROM \"hazelcast\".\"public\".\"map2\" AS \"map2\"");
    }

    @Test
    public void when_createsViewWithExistingName_then_throws() {
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
        Assertions.assertThat((Object)viewStorage.get((Object)"v")).isInstanceOf(View.class);
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("Mapping or view already exists: v");
    }

    @Test
    public void when_replaceViewWithIfNotExists_then_throws() {
        String sql = "CREATE OR REPLACE VIEW IF NOT EXISTS v AS SELECT * FROM map";
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("OR REPLACE in conjunction with IF NOT EXISTS not supported");
    }

    @Test
    public void when_createsViewWithExistingMappingWithEqualName_then_throws() {
        CreateViewStatementTest.createMapping("v", Integer.class, Integer.class);
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("Mapping or view already exists: v");
    }

    @Test
    public void when_incorrectQuery_then_fails() {
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute("CREATE VIEW v AS SELECT -", new Object[0])).hasMessageContaining("Encountered \"<EOF>\" at line 1");
    }

    @Test
    public void when_dropView_then_succeeds() {
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
        sql = "DROP VIEW v";
        CreateViewStatementTest.instance().getSql().execute(sql, new Object[0]);
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isFalse();
    }

    @Test
    public void when_dropAbsentViewWithIfExists_then_throws() {
        String sql = "DROP VIEW v";
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute(sql, new Object[0])).hasMessageContaining("View does not exist: v");
    }

    @Test
    public void test_fullyQualifiedName() {
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        CreateViewStatementTest.instance().getSql().execute("CREATE VIEW hazelcast.public.v AS SELECT 1", new Object[0]);
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
        CreateViewStatementTest.assertRowsAnyOrder("SELECT * FROM v", CreateViewStatementTest.rows(1, (byte)1));
        CreateViewStatementTest.instance().getSql().execute("DROP VIEW hazelcast.public.v", new Object[0]);
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isFalse();
    }

    @Test
    public void test_failOnIncorrectSchema() {
        IMap viewStorage = CreateViewStatementTest.instance().getMap("__sql.catalog");
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute("CREATE VIEW information_schema.v AS SELECT 1", new Object[0])).hasMessageContaining("The view must be created in the \"public\" schema");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isFalse();
        CreateViewStatementTest.instance().getSql().execute("CREATE VIEW hazelcast.public.v AS SELECT 1", new Object[0]);
        Assertions.assertThatThrownBy(() -> CreateViewStatementTest.instance().getSql().execute("DROP VIEW information_schema.v", new Object[0]).updateCount()).hasMessageContaining("View does not exist: information_schema.v");
        Assertions.assertThat((boolean)viewStorage.containsKey((Object)"v")).isTrue();
    }
}

