/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.DeltaJobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.JobAssertions;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.exception.CancellationByUserException;
import com.hazelcast.jet.sql.impl.SqlEndToEndTestSupport;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AnalyzeStatementTest
extends SqlEndToEndTestSupport {
    @BeforeClass
    public static void beforeClass() {
        AnalyzeStatementTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_options() {
        AnalyzeStatementTest.createMapping("test", Long.class, String.class);
        Assert.assertFalse((boolean)this.assertQueryPlan("SELECT * FROM test").isAnalyzed());
        Assert.assertTrue((boolean)this.assertQueryPlan("ANALYZE SELECT * FROM test").isAnalyzed());
        SqlPlanImpl.SelectPlan plan = this.assertQueryPlan("ANALYZE WITH OPTIONS('processingGuarantee'='exactlyOnce', 'snapshotIntervalMillis'='121', 'initialSnapshotName'='pressF', 'maxProcessorAccumulatedRecords'='100') SELECT * FROM test");
        Assert.assertTrue((boolean)plan.isAnalyzed());
        Assert.assertFalse((boolean)plan.analyzeJobConfig().isSplitBrainProtectionEnabled());
        Assert.assertFalse((boolean)plan.analyzeJobConfig().isAutoScaling());
        Assert.assertFalse((boolean)plan.analyzeJobConfig().isSuspendOnFailure());
        Assert.assertTrue((boolean)plan.analyzeJobConfig().isMetricsEnabled());
        Assert.assertTrue((boolean)plan.analyzeJobConfig().isStoreMetricsAfterJobCompletion());
        Assert.assertEquals((Object)ProcessingGuarantee.EXACTLY_ONCE, (Object)plan.analyzeJobConfig().getProcessingGuarantee());
        Assert.assertEquals((long)121L, (long)plan.analyzeJobConfig().getSnapshotIntervalMillis());
        Assert.assertEquals((Object)"pressF", (Object)plan.analyzeJobConfig().getInitialSnapshotName());
        Assert.assertEquals((long)100L, (long)plan.analyzeJobConfig().getMaxProcessorAccumulatedRecords());
    }

    @Test
    public void test_overridableOptions() {
        AnalyzeStatementTest.createMapping("test", Long.class, String.class);
        SqlPlanImpl.SelectPlan plan = this.assertQueryPlan("ANALYZE WITH OPTIONS('metricsEnabled'='false', 'storeMetricsAfterJobCompletion'='false') SELECT * FROM test");
        Assert.assertTrue((boolean)plan.isAnalyzed());
        Assert.assertFalse((boolean)plan.analyzeJobConfig().isMetricsEnabled());
        Assert.assertFalse((boolean)plan.analyzeJobConfig().isStoreMetricsAfterJobCompletion());
    }

    @Test
    public void test_useUnsupportedOptionFails() {
        AnalyzeStatementTest.createMapping("test", Long.class, String.class);
        String expectedErrorDescription = "Job option is not supported for ANALYZE";
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE WITH OPTIONS('splitBrainProtectionEnabled'='true') SELECT * FROM test", new Object[0])).hasMessageContaining(expectedErrorDescription);
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE WITH OPTIONS('autoScaling'='true') SELECT * FROM test", new Object[0])).hasMessageContaining(expectedErrorDescription);
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE WITH OPTIONS('suspendOnFailure'='true') SELECT * FROM test", new Object[0])).hasMessageContaining(expectedErrorDescription);
    }

    @Test
    public void test_select() {
        AnalyzeStatementTest.createMapping("test", Long.class, String.class);
        AnalyzeStatementTest.instance().getMap("test").put((Object)1L, (Object)"testVal");
        AnalyzeStatementTest.assertRowsAnyOrder("ANALYZE SELECT * FROM test WHERE TRUE", AnalyzeStatementTest.rows(2, 1L, "testVal"));
        Job job = AnalyzeStatementTest.instance().getJet().getJobs().stream().filter(j -> Objects.equals(j.getConfig().getArgument("__sql.queryText"), "ANALYZE SELECT * FROM test WHERE TRUE")).findFirst().orElse(null);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isLightJob());
        Assertions.assertThat((Collection)job.getMetrics().metrics()).isNotEmpty();
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE SELECT * FROM test WHERE __key = 1", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("This query uses key-based optimized IMap access plan.");
    }

    @Test
    public void test_insert() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        String insertQuery = "INSERT INTO test SELECT v, v from table(generate_series(1,2))";
        Job job = AnalyzeStatementTest.assertJobIsAnalyzed("INSERT INTO test SELECT v, v from table(generate_series(1,2))");
        Assert.assertEquals((long)2L, (long)AnalyzeStatementTest.instance().getMap("test").size());
        Assertions.assertThat((Collection)job.getMetrics().metrics()).isNotEmpty();
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE INSERT INTO test VALUES(3, 3)", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("This query uses key-based optimized IMap access plan.");
    }

    @Test
    public void test_sink() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        String insertQuery = " SINK INTO test SELECT v, v from table(generate_series(1,2))";
        Job job = AnalyzeStatementTest.assertJobIsAnalyzed(" SINK INTO test SELECT v, v from table(generate_series(1,2))");
        Assert.assertEquals((long)2L, (long)AnalyzeStatementTest.instance().getMap("test").size());
        Assertions.assertThat((Collection)job.getMetrics().metrics()).isNotEmpty();
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE SINK INTO test VALUES(3, 3)", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("This query uses key-based optimized IMap access plan.");
    }

    @Test
    public void test_update() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        AnalyzeStatementTest.instance().getMap("test").put((Object)1L, (Object)1L);
        String updateQuery = "UPDATE test SET this = 3 WHERE this = 1 AND this IS NOT NULL";
        Job job = AnalyzeStatementTest.assertJobIsAnalyzed("UPDATE test SET this = 3 WHERE this = 1 AND this IS NOT NULL");
        Assert.assertEquals((Object)3L, (Object)AnalyzeStatementTest.instance().getMap("test").get((Object)1L));
        Assertions.assertThat((Collection)job.getMetrics().metrics()).isNotEmpty();
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE UPDATE test SET this = 3 WHERE __key = 1", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("This query uses key-based optimized IMap access plan.");
    }

    @Test
    public void test_delete() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        AnalyzeStatementTest.instance().getMap("test").put((Object)1L, (Object)1L);
        String deleteQuery = "DELETE FROM test WHERE this = 1 AND this IS NOT NULL";
        Job job = AnalyzeStatementTest.assertJobIsAnalyzed("DELETE FROM test WHERE this = 1 AND this IS NOT NULL");
        Assert.assertTrue((boolean)AnalyzeStatementTest.instance().getMap("test").isEmpty());
        Assertions.assertThat((Collection)job.getMetrics().metrics()).isNotEmpty();
        Assertions.assertThatThrownBy(() -> this.sqlService.execute("ANALYZE DELETE FROM test WHERE __key = 1", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("This query uses key-based optimized IMap access plan.");
    }

    @Test
    public void test_suspendJob() {
        Job job = this.runQuery();
        job.suspend();
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void test_suspendDmlJob() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        Job job = AnalyzeStatementTest.assertAsyncJobIsAnalyzed("INSERT INTO test SELECT v, v from table(generate_stream(1))");
        job.suspend();
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void test_restartJob() {
        Job job = this.runQuery();
        job.restart();
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void test_restartDmlJob() {
        AnalyzeStatementTest.createMapping("test", Long.class, Long.class);
        Job job = AnalyzeStatementTest.assertAsyncJobIsAnalyzed("INSERT INTO test SELECT v, v from table(generate_stream(1))");
        job.restart();
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void test_changeClusterStateToPassive() {
        Job job = this.runQuery();
        AnalyzeStatementTest.instance().getCluster().changeClusterState(ClusterState.PASSIVE);
        AnalyzeStatementTest.instance().getCluster().changeClusterState(ClusterState.ACTIVE);
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void test_updateConfigForAnalyzedQuery() {
        Job job = this.runQuery();
        Assertions.assertThatThrownBy(() -> job.updateConfig(new DeltaJobConfig())).hasMessageContaining("is not suspendable, can't perform `updateJobConfig()`");
        AnalyzeStatementTest.assertTrueAllTheTime(() -> Assert.assertEquals((Object)JobStatus.RUNNING, (Object)job.getStatus()), (long)1L);
    }

    @Test
    public void test_listRunningAnalyzedQueryWithSqlSummary() {
        String query = "SELECT v from table(generate_stream(1))";
        String sql = "ANALYZE SELECT v from table(generate_stream(1))";
        this.sqlService.execute("ANALYZE SELECT v from table(generate_stream(1))", new Object[0]);
        AnalyzeStatementTest.awaitSingleRunningJob((HazelcastInstance)AnalyzeStatementTest.instance());
        List jobSummaries = ((JetClientInstanceImpl)AnalyzeStatementTest.client().getJet()).getJobAndSqlSummaryList();
        Assertions.assertThat((List)jobSummaries).hasOnlyOneElementSatisfying(jobSummary -> {
            Assertions.assertThat((Comparable)jobSummary.getStatus()).isEqualTo((Object)JobStatus.RUNNING);
            Assertions.assertThat((Object)jobSummary.getSqlSummary()).isNotNull();
            Assert.assertEquals((Object)"ANALYZE SELECT v from table(generate_stream(1))", (Object)jobSummary.getSqlSummary().getQuery());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)jobSummary.getSqlSummary().isUnbounded());
            Assertions.assertThat((boolean)jobSummary.isUserCancelled()).isFalse();
        });
    }

    @Test
    public void test_listFinishedAnalyzedQueryWithSqlSummary() {
        String query = "SELECT v from table(generate_series(1,2))";
        String sql = "ANALYZE SELECT v from table(generate_series(1,2))";
        try (SqlResult result = this.sqlService.execute("ANALYZE SELECT v from table(generate_series(1,2))", new Object[0]);){
            result.stream().count();
        }
        AnalyzeStatementTest.assertTrueEventually(() -> {
            List jobSummaries = ((JetClientInstanceImpl)AnalyzeStatementTest.client().getJet()).getJobAndSqlSummaryList();
            Assertions.assertThat((List)jobSummaries).hasOnlyOneElementSatisfying(jobSummary -> {
                Assertions.assertThat((Comparable)jobSummary.getStatus()).isEqualTo((Object)JobStatus.COMPLETED);
                Assertions.assertThat((Object)jobSummary.getSqlSummary()).isNotNull();
                Assert.assertEquals((Object)"ANALYZE SELECT v from table(generate_series(1,2))", (Object)jobSummary.getSqlSummary().getQuery());
                Assert.assertEquals((Object)Boolean.FALSE, (Object)jobSummary.getSqlSummary().isUnbounded());
                Assertions.assertThat((boolean)jobSummary.isUserCancelled()).isFalse();
            });
        });
    }

    @Test
    public void test_listClosedAnalyzedQueryWithSqlSummary() {
        String query = "SELECT v from table(generate_stream(1))";
        String sql = "ANALYZE SELECT v from table(generate_stream(1))";
        SqlResult result = this.sqlService.execute("ANALYZE SELECT v from table(generate_stream(1))", new Object[0]);
        Job job = AnalyzeStatementTest.awaitSingleRunningJob((HazelcastInstance)AnalyzeStatementTest.instance());
        result.close();
        JobAssertions.assertThat((Job)job).eventuallyHasStatus(JobStatus.FAILED);
        List jobSummaries = ((JetClientInstanceImpl)AnalyzeStatementTest.client().getJet()).getJobAndSqlSummaryList();
        Assertions.assertThat((List)jobSummaries).hasOnlyOneElementSatisfying(jobSummary -> {
            Assertions.assertThat((Comparable)jobSummary.getStatus()).isEqualTo((Object)JobStatus.FAILED);
            Assertions.assertThat((Object)jobSummary.getSqlSummary()).isNotNull();
            Assert.assertEquals((Object)"ANALYZE SELECT v from table(generate_stream(1))", (Object)jobSummary.getSqlSummary().getQuery());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)jobSummary.getSqlSummary().isUnbounded());
            Assertions.assertThat((boolean)jobSummary.isUserCancelled()).isTrue();
        });
    }

    @Test
    public void test_closeCursor() {
        String query = "SELECT v, v FROM TABLE(generate_stream(1))";
        SqlResult result = AnalyzeStatementTest.instance().getSql().execute("ANALYZE " + query, new Object[0]);
        Job job = AnalyzeStatementTest.awaitSingleRunningJob((HazelcastInstance)AnalyzeStatementTest.instance());
        Job jobByIdBeforeTermination = AnalyzeStatementTest.instance().getJet().getJob(job.getId());
        result.stream().findFirst();
        result.close();
        AnalyzeStatementTest.joinAndExpectUserCancellation(job);
        AnalyzeStatementTest.joinAndExpectUserCancellation(jobByIdBeforeTermination);
        Job jobById = AnalyzeStatementTest.instance().getJet().getJob(job.getId());
        AnalyzeStatementTest.joinAndExpectUserCancellation(jobById);
    }

    private Job runQuery() {
        String query = "SELECT v, v FROM TABLE(generate_stream(1))";
        AnalyzeStatementTest.instance().getSql().execute("ANALYZE " + query, new Object[0]);
        Job job = AnalyzeStatementTest.findJobForQuery("ANALYZE " + query);
        Assert.assertNotNull((Object)job);
        JobAssertions.assertThat((Job)job).eventuallyHasStatus(JobStatus.RUNNING);
        return job;
    }

    private static Job assertJobIsAnalyzed(String query) {
        AnalyzeStatementTest.instance().getSql().execute("ANALYZE " + query, new Object[0]);
        Job job = AnalyzeStatementTest.findJobForQuery("ANALYZE " + query);
        Assert.assertNotNull((Object)job);
        Assert.assertFalse((boolean)job.isLightJob());
        return job;
    }

    private static Job assertAsyncJobIsAnalyzed(String query) {
        new Thread(() -> AnalyzeStatementTest.instance().getSql().execute("ANALYZE " + query, new Object[0])).start();
        AnalyzeStatementTest.assertTrueEventually(() -> {
            Job job = AnalyzeStatementTest.findJobForQuery("ANALYZE " + query);
            Assert.assertNotNull((Object)job);
            Assert.assertFalse((boolean)job.isLightJob());
        });
        Job job = AnalyzeStatementTest.findJobForQuery("ANALYZE " + query);
        JobAssertions.assertThat((Job)job).eventuallyHasStatus(JobStatus.RUNNING);
        return job;
    }

    @Nullable
    private static Job findJobForQuery(String query) {
        return AnalyzeStatementTest.instance().getJet().getJobs().stream().filter(j -> Objects.equals(j.getConfig().getArgument("__sql.queryText"), query)).findFirst().orElse(null);
    }

    private static void joinAndExpectUserCancellation(Job job) {
        Assertions.assertThatThrownBy(() -> ((Job)job).join()).isInstanceOf(CancellationByUserException.class);
        Assertions.assertThat((boolean)job.isUserCancelled()).isTrue();
    }
}

