/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlUnionTest
extends SqlTestSupport {
    private IMap<Integer, Person> map1;
    private IMap<Integer, Person> map2;
    private IMap<Integer, Person> map3;
    private final List<SqlTestSupport.Row> expected = new ArrayList<SqlTestSupport.Row>();

    @BeforeClass
    public static void beforeClass() {
        SqlUnionTest.initialize((int)3, null);
    }

    @Before
    public void before() throws Exception {
        this.map1 = SqlUnionTest.instance().getMap("map1");
        this.map2 = SqlUnionTest.instance().getMap("map2");
        this.map3 = SqlUnionTest.instance().getMap("map3");
    }

    @Test
    public void baseUnionTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Person.class);
        for (int i = 0; i < 50; ++i) {
            this.map1.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map2.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.expected.add(new SqlTestSupport.Row(i, i, "ABC" + i));
        }
        String sql = "(SELECT * FROM map1) UNION (SELECT * FROM map2)";
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void multipleUnionTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Person.class);
        SqlUnionTest.createMapping("map3", Integer.class, Person.class);
        for (int i = 0; i < 50; ++i) {
            this.map1.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map2.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map3.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.expected.add(new SqlTestSupport.Row(i, i, "ABC" + i));
        }
        String sql = "(SELECT * FROM map1) UNION (SELECT * FROM map2) UNION (SELECT * FROM map3)";
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void baseUnionAllTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Person.class);
        for (int i = 0; i < 50; ++i) {
            this.map1.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map2.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.expected.add(new SqlTestSupport.Row(i, i, "ABC" + i));
            this.expected.add(new SqlTestSupport.Row(i, i, "ABC" + i));
        }
        String sql = "(SELECT * FROM map1) UNION ALL (SELECT * FROM map2)";
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void multipleUnionAllTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Person.class);
        SqlUnionTest.createMapping("map3", Integer.class, Person.class);
        for (int i = 0; i < 50; ++i) {
            this.map1.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map2.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.map3.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.expected.addAll(Arrays.asList(new SqlTestSupport.Row(i, i, "ABC" + i), new SqlTestSupport.Row(i, i, "ABC" + i), new SqlTestSupport.Row(i, i, "ABC" + i)));
        }
        String sql = "(SELECT * FROM map1) UNION ALL (SELECT * FROM map2) UNION ALL (SELECT * FROM map3)";
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void baseUnionColumnCountMismatchTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Integer.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT * FROM map1) UNION (SELECT __key FROM map2)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Column count mismatch in UNION");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT __key FROM map1) UNION (SELECT * FROM map2)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Column count mismatch in UNION");
    }

    @Test
    public void baseUnionTypeMismatchErrorTest() {
        SqlUnionTest.instance().getMap("map4");
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map4", Integer.class, Integer.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT name FROM map1) UNION (SELECT this FROM map4)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Cannot infer return type for UNION");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT this FROM map4) UNION (SELECT name FROM map1)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Cannot infer return type for UNION");
    }

    @Test
    public void baseUnionAllColumnCountMismatchTest() {
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map2", Integer.class, Person.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT * FROM map1) UNION ALL (SELECT __key FROM map2)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Column count mismatch in UNION");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT __key FROM map1) UNION ALL (SELECT * FROM map2)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Column count mismatch in UNION");
    }

    @Test
    public void baseUnionAllTypeMismatchErrorTest() {
        SqlUnionTest.instance().getMap("map4");
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        SqlUnionTest.createMapping("map4", Integer.class, Integer.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT name FROM map1) UNION ALL (SELECT this FROM map4)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Cannot infer return type for UNION ALL");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute("(SELECT this FROM map4) UNION ALL (SELECT name FROM map1)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Cannot infer return type for UNION ALL");
    }

    @Test
    public void test_unionOfTableScanAndValues() {
        this.map1 = SqlUnionTest.instance().getMap("map1");
        SqlUnionTest.createMapping("map1", Integer.class, Person.class);
        for (int i = 0; i < 50; ++i) {
            this.map1.put((Object)i, (Object)new Person(i, "ABC" + i));
            this.expected.add(new SqlTestSupport.Row((byte)1));
        }
        this.expected.add(new SqlTestSupport.Row((byte)1));
        String sql = "SELECT 1 FROM (values(1)) UNION ALL SELECT 1 FROM map1";
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void watermarkedStreamUnionTest() {
        String name = SqlUnionTest.createTable(SqlUnionTest.row(SqlUnionTest.timestampTz(10L), 1), SqlUnionTest.row(SqlUnionTest.timestampTz(12L), 2), SqlUnionTest.row(SqlUnionTest.timestampTz(14L), 3), SqlUnionTest.row(SqlUnionTest.timestampTz(0L), 4));
        String sql = "SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND))";
        String query = sql + " UNION " + sql;
        Assertions.assertThatThrownBy(() -> SqlUnionTest.instance().getSql().execute(query, new Object[0])).hasMessageContaining("Streaming aggregation is supported only for window aggregation");
    }

    @Test
    public void watermarkedStreamUnionAllTest() {
        String name = SqlUnionTest.createTable(SqlUnionTest.row(SqlUnionTest.timestampTz(100L), 1), SqlUnionTest.row(SqlUnionTest.timestampTz(120L), 2), SqlUnionTest.row(SqlUnionTest.timestampTz(140L), 3), SqlUnionTest.row(SqlUnionTest.timestampTz(0L), 4));
        String sql = "SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.001' SECOND))";
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(100L), 1));
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(100L), 1));
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(120L), 2));
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(120L), 2));
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(140L), 3));
        this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(140L), 3));
        SqlResult result = SqlUnionTest.instance().getSql().execute(sql + " UNION ALL " + sql, new Object[0]);
        ResultIterator iterator = (ResultIterator)result.iterator();
        ArrayList actualRows = new ArrayList();
        SqlUnionTest.assertTrueEventually(() -> {
            while (iterator.hasNext(50L, TimeUnit.MILLISECONDS) == ResultIterator.HasNextResult.YES) {
                actualRows.add(new SqlTestSupport.Row((SqlRow)iterator.next()));
            }
            if (actualRows.size() == 7 && this.expected.size() < 7) {
                this.expected.add(new SqlTestSupport.Row(SqlUnionTest.timestampTz(0L), 4));
            }
            Assertions.assertThat((List)actualRows).containsExactlyInAnyOrderElementsOf(this.expected);
        }, (long)5L);
    }

    @Test
    public void prunableUnionAllTest() {
        String map1Name = SqlUnionTest.randomName();
        String map2Name = SqlUnionTest.randomName();
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig(map1Name).setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig(map2Name).setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        IMap prunableMap1 = SqlUnionTest.instance().getMap(map1Name);
        IMap prunableMap2 = SqlUnionTest.instance().getMap(map2Name);
        SqlUnionTest.createMapping(map1Name, Person.class, String.class);
        SqlUnionTest.createMapping(map2Name, Person.class, String.class);
        for (int i = 0; i < 5; ++i) {
            prunableMap1.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
            prunableMap2.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
        }
        String sql = "(SELECT this FROM " + map1Name + " WHERE id = 1) UNION ALL (SELECT this FROM " + map2Name + " WHERE id = 1)";
        this.expected.add(new SqlTestSupport.Row("1"));
        this.expected.add(new SqlTestSupport.Row("1"));
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void prunableUnionTest() {
        String map1Name = SqlUnionTest.randomName();
        String map2Name = SqlUnionTest.randomName();
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig(map1Name).setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig(map2Name).setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        IMap prunableMap1 = SqlUnionTest.instance().getMap(map1Name);
        IMap prunableMap2 = SqlUnionTest.instance().getMap(map2Name);
        SqlUnionTest.createMapping(map1Name, Person.class, String.class);
        SqlUnionTest.createMapping(map2Name, Person.class, String.class);
        for (int i = 0; i < 5; ++i) {
            prunableMap1.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
            prunableMap2.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
        }
        String sql = "(SELECT this FROM " + map1Name + " WHERE id = 1) UNION (SELECT this FROM " + map2Name + " WHERE id = 1)";
        this.expected.add(new SqlTestSupport.Row("1"));
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void prunableSelfUnionAllTest() {
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig("pMap1").setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        IMap prunableMap1 = SqlUnionTest.instance().getMap("pMap1");
        SqlUnionTest.createMapping("pMap1", Person.class, String.class);
        for (int i = 0; i < 5; ++i) {
            prunableMap1.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
        }
        String sql = "(SELECT this FROM pMap1 WHERE id = 1) UNION ALL (SELECT this FROM pMap1 WHERE id = 1)";
        this.expected.add(new SqlTestSupport.Row("1"));
        this.expected.add(new SqlTestSupport.Row("1"));
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    @Test
    public void prunableSelfUnionTest() {
        SqlUnionTest.instance().getConfig().addMapConfig(new MapConfig("pMap1").setPartitioningAttributeConfigs(List.of(new PartitioningAttributeConfig("id"))));
        IMap prunableMap1 = SqlUnionTest.instance().getMap("pMap1");
        SqlUnionTest.createMapping("pMap1", Person.class, String.class);
        SqlUnionTest.createMapping("pMap2", Person.class, String.class);
        for (int i = 0; i < 5; ++i) {
            prunableMap1.put((Object)new Person(i, "ABC" + i), (Object)String.valueOf(i));
        }
        String sql = "(SELECT this FROM pMap1 WHERE id = 1) UNION (SELECT this FROM pMap1 WHERE id = 1)";
        this.expected.add(new SqlTestSupport.Row("1"));
        SqlUnionTest.assertRowsAnyOrder(sql, this.expected);
    }

    private static String createTable(Object[] ... values) {
        String name = SqlUnionTest.randomName();
        TestStreamSqlConnector.create(SqlUnionTest.instance().getSql(), name, Arrays.asList("ts", "id"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.INTEGER), values);
        return name;
    }
}

