/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlStatefulDagTest
extends SqlTestSupport {
    private static MiniDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        SqlStatefulDagTest.assumeThatNoWindowsOS();
        SqlStatefulDagTest.assumeHadoopSupportsIbmPlatform();
        SqlStatefulDagTest.initialize((int)1, null);
        File directory = Files.createTempDirectory("sql-test-hdfs", new FileAttribute[0]).toFile().getAbsoluteFile();
        directory.deleteOnExit();
        Configuration configuration = new Configuration();
        configuration.set("hdfs.minidfs.basedir", directory.getAbsolutePath());
        cluster = new MiniDFSCluster.Builder(configuration).build();
        cluster.waitClusterUp();
    }

    @Test
    public void testReadHadoop() throws IOException {
        SqlStatefulDagTest.store("/csv/file.csv", "id,name\n1,Alice\n2,Bob");
        String name = SqlStatefulDagTest.randomName();
        SqlStatefulDagTest.instance().getSql().execute("CREATE MAPPING " + name + " (id INT, name VARCHAR) TYPE File OPTIONS (  'format' = 'csv',  'path' = '" + String.valueOf(cluster.getFileSystem().getUri()) + "/csv');", new Object[0]);
        for (int i = 0; i < 2; ++i) {
            SqlStatefulDagTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row(1, "Alice"), new SqlTestSupport.Row(2, "Bob")));
        }
    }

    @AfterClass
    public static void cleanup() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private static void store(String path, String content) throws IOException {
        try (FSDataOutputStream output = cluster.getFileSystem().create(new Path(path));){
            output.writeBytes(content);
        }
    }
}

