/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlSchemaPropagationTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final String SCHEMA_NAME = "schema";

    @BeforeClass
    public static void setUpClass() {
        SqlSchemaPropagationTest.initializeWithClient((int)1, null, null);
    }

    @Before
    public void before() {
        SqlSchemaPropagationTest.createMapping(MAP_NAME, Integer.TYPE, Integer.TYPE);
        SqlSchemaPropagationTest.instance().getMap(MAP_NAME).put((Object)1, (Object)1);
    }

    @Test
    public void testMember() {
        this.check(SqlSchemaPropagationTest.instance());
    }

    @Test
    public void testClient() {
        this.check(SqlSchemaPropagationTest.client());
    }

    private void check(HazelcastInstance target) {
        SqlServiceImpl service = (SqlServiceImpl)SqlSchemaPropagationTest.instance().getSql();
        SqlStatement statement = new SqlStatement("SELECT __key FROM map");
        List<SqlRow> rows = SqlSchemaPropagationTest.executeStatement(target, statement);
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertEquals((long)1L, (long)((Integer)rows.get(0).getObject(0)).intValue());
        Assert.assertEquals((long)1L, (long)service.getPlanCache().size());
        List originalSearchPaths = (List)Iterables.getOnlyElement(this.extractSearchPaths());
        statement.setSchema(SCHEMA_NAME);
        rows = SqlSchemaPropagationTest.executeStatement(target, statement);
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertEquals((long)1L, (long)((Integer)rows.get(0).getObject(0)).intValue());
        Assert.assertEquals((long)2L, (long)service.getPlanCache().size());
        List<List<List<String>>> searchPaths = this.extractSearchPaths();
        ArrayList<List<String>> expectedSearchPaths = new ArrayList<List<String>>(originalSearchPaths);
        expectedSearchPaths.add(0, Arrays.asList("hazelcast", SCHEMA_NAME));
        Assertions.assertThat(searchPaths).containsExactlyInAnyOrder((Object[])new List[]{originalSearchPaths, expectedSearchPaths});
    }

    private static List<SqlRow> executeStatement(HazelcastInstance member, SqlStatement query) {
        ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
        try (SqlResult result = member.getSql().execute(query);){
            for (SqlRow row : result) {
                rows.add(row);
            }
        }
        return rows;
    }

    private List<List<List<String>>> extractSearchPaths() {
        return ((SqlServiceImpl)SqlSchemaPropagationTest.instance().getSql()).getPlanCache().getPlans().values().stream().map(plan -> plan.getPlanKey().getSearchPaths()).collect(Collectors.toList());
    }
}

