/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlQueryResultTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final String SQL_READ = "SELECT * FROM map";
    private static final String SQL_DELETE = "DELETE FROM map WHERE __key = 1";

    @BeforeClass
    public static void setUpClass() {
        SqlQueryResultTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_member() {
        this.check(false);
    }

    @Test
    public void test_client() {
        this.check(true);
    }

    private void check(boolean client) {
        HazelcastInstance member = SqlQueryResultTest.instance();
        HazelcastInstance target = client ? SqlQueryResultTest.client() : SqlQueryResultTest.instance();
        SqlQueryResultTest.createMapping(MAP_NAME, Integer.TYPE, Integer.TYPE);
        member.getMap(MAP_NAME).put((Object)1, (Object)1);
        List<SqlRow> expectedRows = this.execute(SQL_READ);
        Assert.assertEquals((long)1L, (long)expectedRows.size());
        this.checkSuccess(target, SQL_READ, SqlExpectedResultType.ANY, expectedRows, -1);
        this.checkSuccess(target, SQL_READ, SqlExpectedResultType.ROWS, expectedRows, -1);
        this.checkFailure(target, SQL_READ, SqlExpectedResultType.UPDATE_COUNT);
        this.checkSuccess(target, SQL_DELETE, SqlExpectedResultType.ANY, Collections.emptyList(), 0);
        this.checkFailure(target, SQL_DELETE, SqlExpectedResultType.ROWS);
        this.checkSuccess(target, SQL_DELETE, SqlExpectedResultType.UPDATE_COUNT, Collections.emptyList(), 0);
    }

    private List<SqlRow> execute(String query) {
        try (SqlResult result = SqlQueryResultTest.instance().getSql().execute(query, new Object[0]);){
            List<SqlRow> list = result.stream().collect(Collectors.toList());
            return list;
        }
    }

    private void checkSuccess(HazelcastInstance target, String sql, SqlExpectedResultType type, List<SqlRow> expectedRows, int expectedUpdateCount) {
        SqlResult result = target.getSql().execute(new SqlStatement(sql).setExpectedResultType(type));
        Assert.assertEquals((long)expectedUpdateCount, (long)result.updateCount());
        if (expectedUpdateCount >= 0) {
            return;
        }
        ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
        for (SqlRow row : result) {
            rows.add(row);
        }
        Assert.assertEquals((long)expectedRows.size(), (long)rows.size());
        for (int i = 0; i < expectedRows.size(); ++i) {
            SqlRow expectedRow = expectedRows.get(i);
            SqlRow row = (SqlRow)rows.get(i);
            Assert.assertEquals((Object)expectedRow.getMetadata(), (Object)row.getMetadata());
            for (int j = 0; j < expectedRow.getMetadata().getColumnCount(); ++j) {
                Object expectedValue = expectedRow.getObject(j);
                Object value = row.getObject(j);
                Assert.assertEquals((Object)expectedValue, (Object)value);
            }
        }
    }

    private void checkFailure(HazelcastInstance target, String sql, SqlExpectedResultType type) {
        assert (type == SqlExpectedResultType.ROWS || type == SqlExpectedResultType.UPDATE_COUNT) : type;
        try (SqlResult result = target.getSql().execute(new SqlStatement(sql).setExpectedResultType(type));){
            result.iterator().forEachRemaining(row -> {});
            Assert.fail((String)"Must fail");
        }
        catch (HazelcastSqlException e) {
            String message = e.getMessage();
            if (type == SqlExpectedResultType.ROWS) {
                Assert.assertEquals((Object)"The statement doesn't produce rows", (Object)message);
            }
            Assert.assertEquals((Object)"The statement doesn't produce update count", (Object)message);
        }
    }
}

