/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlJsonTypeTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() {
        SqlJsonTypeTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_insertIntoExistingMap() {
        IMap test = SqlJsonTypeTest.instance().getMap("test");
        SqlJsonTypeTest.createMapping("test", "bigint", "json");
        test.put((Object)1L, (Object)SqlJsonTypeTest.json("[1,2,3]"));
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[1,2,3]")));
        this.execute("INSERT INTO test VALUES (2, CAST('[4,5,6]' AS JSON))", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[1,2,3]"), 2L, SqlJsonTypeTest.json("[4,5,6]")));
        this.execute("DELETE FROM test WHERE __key = 1", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT * FROM test", SqlJsonTypeTest.rows(2, 2L, SqlJsonTypeTest.json("[4,5,6]")));
    }

    @Test
    public void test_sinkIntoExistingMap() {
        SqlJsonTypeTest.createMapping("test", "bigint", "json");
        this.execute("INSERT INTO test VALUES (1, CAST('[1,2,3]' AS JSON))", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[1,2,3]")));
        this.execute("SINK INTO test SELECT 1, CAST('[4,5,6]' AS JSON)", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[4,5,6]")));
    }

    @Test
    public void test_client_useJsonValue() {
        SqlJsonTypeTest.createMapping(SqlJsonTypeTest.client(), "test", "bigint", "json");
        this.executeClient("INSERT INTO test VALUES (1, CAST('[4,5,6]' AS JSON))", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test WHERE __key=1", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[4,5,6]")));
        this.executeClient("INSERT INTO test VALUES (2, ?)", SqlJsonTypeTest.json("[7,8,9]"));
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test WHERE __key=2", SqlJsonTypeTest.rows(2, 2L, SqlJsonTypeTest.json("[7,8,9]")));
        this.executeClient("INSERT INTO test VALUES (3, CAST('[10,11,12]' AS JSON)), (4, ?)", SqlJsonTypeTest.json("[13,14,15]"));
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test WHERE __key>=3", SqlJsonTypeTest.rows(2, 3L, SqlJsonTypeTest.json("[10,11,12]"), 4L, SqlJsonTypeTest.json("[13,14,15]")));
        this.executeClient("INSERT INTO test VALUES (5, '[16,17,18]'), (6, ?)", SqlJsonTypeTest.json("[19,20,21]"));
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test WHERE __key>=5", SqlJsonTypeTest.rows(2, 5L, SqlJsonTypeTest.json("[16,17,18]"), 6L, SqlJsonTypeTest.json("[19,20,21]")));
    }

    @Test
    public void test_client_useStringValue() {
        SqlJsonTypeTest.createMapping(SqlJsonTypeTest.client(), "test", "bigint", "json");
        IMap test = SqlJsonTypeTest.client().getMap("test");
        test.put((Object)1L, (Object)SqlJsonTypeTest.json("[1,2,3]"));
        this.executeClient("INSERT INTO test VALUES (2, '[4,5,6]')", new Object[0]);
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[1,2,3]"), 2L, SqlJsonTypeTest.json("[4,5,6]")));
        this.executeClient("INSERT INTO test VALUES (3, ?)", "[7,8,9]");
        SqlJsonTypeTest.assertRowsAnyOrder(SqlJsonTypeTest.client(), "SELECT * FROM test", SqlJsonTypeTest.rows(2, 1L, SqlJsonTypeTest.json("[1,2,3]"), 2L, SqlJsonTypeTest.json("[4,5,6]"), 3L, SqlJsonTypeTest.json("[7,8,9]")));
    }

    @Test
    public void test_jsonEqualComparedAsVarchar() {
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS JSON) = CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) = CAST('{\"f1\":42, \"f2\":43}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) = '{\"f2\":43, \"f1\":42}','{\"f1\":42, \"f2\":43}' = CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) = '{\"f1\":42, \"f2\":43}','{\"f1\":42, \"f2\":43}' = CAST('{\"f1\":42, \"f2\":43}' AS JSON)", SqlJsonTypeTest.rows(6, false, true, false, false, true, true));
    }

    @Test
    public void test_jsonNotEqualComparedAsVarchar() {
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS JSON) != CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) != CAST('{\"f1\":42, \"f2\":43}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) != '{\"f2\":43, \"f1\":42}','{\"f1\":42, \"f2\":43}' != CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) != '{\"f1\":42, \"f2\":43}','{\"f1\":42, \"f2\":43}' != CAST('{\"f1\":42, \"f2\":43}' AS JSON)", SqlJsonTypeTest.rows(6, true, false, true, true, false, false));
    }

    @Test
    public void test_jsonLessComparedAsVarchar() {
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS JSON) < CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) < CAST('{\"f1\":42, \"f2\":43}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) < '{\"f2\":43, \"f1\":42}','{\"f1\":42, \"f2\":43}' < CAST('{\"f2\":43, \"f1\":42}' AS JSON),CAST('{\"f1\":42, \"f2\":43}' AS JSON) < '{\"f1\":42, \"f2\":43}','{\"f1\":42, \"f2\":43}' < CAST('{\"f1\":42, \"f2\":43}' AS JSON)", SqlJsonTypeTest.rows(6, true, false, true, true, false, false));
    }

    @Test
    public void test_jsonLengthNotSupported() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.execute("SELECT LENGTH(CAST('{\"f1\":42, \"f2\":43}' AS JSON))", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Cannot apply 'LENGTH' function to [JSON] (consider adding an explicit CAST)");
    }

    @Test
    public void test_jsonSubstringNotSupported() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.execute("SELECT SUBSTRING(CAST('{\"f1\":42, \"f2\":43}' AS JSON) FROM 1 FOR 5)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageEndingWith("Cannot apply 'SUBSTRING' function to [JSON, INTEGER, INTEGER] (consider adding an explicit CAST)");
    }

    @Test
    public void test_jsonConcat() {
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS JSON) || CAST('suffix' AS VARCHAR)", SqlJsonTypeTest.rows(1, "{\"f1\":42, \"f2\":43}suffix"));
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS VARCHAR) || CAST('suffix' AS JSON)", SqlJsonTypeTest.rows(1, "{\"f1\":42, \"f2\":43}suffix"));
        SqlJsonTypeTest.assertRowsAnyOrder("SELECT CAST('{\"f1\":42, \"f2\":43}' AS JSON) || CAST('suffix' AS JSON)", SqlJsonTypeTest.rows(1, "{\"f1\":42, \"f2\":43}suffix"));
    }

    public void execute(String sql, Object ... arguments) {
        SqlJsonTypeTest.instance().getSql().execute(sql, arguments);
    }

    public void executeClient(String sql, Object ... arguments) {
        SqlJsonTypeTest.client().getSql().execute(sql, arguments);
    }
}

