/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlExpandViewTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private IMap<Integer, Integer> map;

    @BeforeClass
    public static void beforeClass() {
        SqlExpandViewTest.initialize((int)1, null);
    }

    @Before
    public void setUp() throws Exception {
        this.map = SqlExpandViewTest.instance().getMap(MAP_NAME);
        SqlExpandViewTest.createMapping(MAP_NAME, Integer.TYPE, Integer.TYPE);
        this.map.put((Object)1, (Object)1);
    }

    @Test
    public void test_simpleView() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void when_circularViews_then_fails() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v1 AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v2 AS SELECT * FROM v1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE OR REPLACE VIEW v1 AS SELECT * FROM v2", new Object[0]);
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("SELECT * FROM v1", new Object[0])).hasMessageContaining("Cycle detected in view references");
    }

    @Test
    public void test_viewWithDistinctSelect() {
        this.map.put((Object)1, (Object)1);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT DISTINCT * FROM v", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void test_viewWithinWhereClause() {
        this.map.put((Object)1, (Object)1);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM map WHERE EXISTS (SELECT * FROM v WHERE __key = map.__key)", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM map WHERE EXISTS (SELECT * FROM v WHERE v.__key = map.__key)", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void when_viewAfterMappingRemovedIsExpanded_then_fails() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("DROP MAPPING map", new Object[0]);
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0])).hasMessageContaining("Object 'map' not found, did you forget to CREATE MAPPING?");
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("SELECT * FROM v", new Object[0])).hasMessageContaining("Object 'map' not found within 'hazelcast.public', did you forget to CREATE MAPPING? If you want to use");
    }

    @Test
    public void test_viewWithStreamingQuery() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM TABLE(GENERATE_STREAM(10))", new Object[0]);
        SqlExpandViewTest.assertTipOfStream("SELECT * FROM v", SqlExpandViewTest.rows(1, 0L, 1L, 2L));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v LIMIT 1", SqlExpandViewTest.rows(1, 0L));
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("SELECT * FROM v ORDER BY 1", new Object[0])).hasMessageContaining("Sorting is not supported for a streaming query");
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("SELECT MAX(v) FROM v", new Object[0])).hasMessageContaining("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void when_dml_then_fail() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("insert into v values(42, 43)", new Object[0])).hasMessageContaining("DML operations not supported for views");
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("update v set this=44 where __key=42", new Object[0])).hasMessageContaining("DML operations not supported for views");
        Assertions.assertThatThrownBy(() -> SqlExpandViewTest.instance().getSql().execute("delete from v where __key=42", new Object[0])).hasMessageContaining("DML operations not supported for views");
    }

    @Test
    public void test_referencedViewChanged() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v1 AS SELECT __key FROM map", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v2 AS SELECT __key FROM v1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE or replace VIEW v1 AS SELECT 'key=' || __key __key FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("select * from v2", SqlExpandViewTest.rows(1, "key=1"));
    }

    @Test
    public void test_fullyQualifiedViewName() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        List<SqlTestSupport.Row> expectedRows = Collections.singletonList(new SqlTestSupport.Row(1, 1));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", expectedRows);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM public.v", expectedRows);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM hazelcast.public.v", expectedRows);
    }

    @Test
    public void when_viewIsExpandedWithQueryFilter() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v WHERE __key > 1", Collections.emptyList());
    }

    @Test
    public void when_viewIsExpandedWithViewFilter() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE __key > 1", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.emptyList());
    }

    @Test
    public void when_viewIsExpandedWithQueryProjection() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT this FROM v", Collections.singletonList(new SqlTestSupport.Row(1)));
    }

    @Test
    public void when_viewIsExpandedWithViewProjection() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT this FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.singletonList(new SqlTestSupport.Row(1)));
    }

    @Test
    public void when_viewIsExpandedWithJoin() {
        String MAP_NAME_2 = "map2";
        IMap map2 = SqlExpandViewTest.instance().getMap("map2");
        SqlExpandViewTest.createMapping("map2", Integer.class, Integer.class);
        map2.put((Object)1, (Object)1);
        String sql = "CREATE VIEW v AS SELECT * FROM map INNER JOIN map2 ON map2.__key = map .__key";
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map INNER JOIN map2 ON map2.__key = map .__key", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.singletonList(new SqlTestSupport.Row(1, 1, 1, 1)));
    }

    @Test
    public void when_viewIsExpandedWithCrossProduct() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v v1 CROSS JOIN v v2", Collections.singletonList(new SqlTestSupport.Row(1, 1, 1, 1)));
    }

    @Test
    public void when_viewIsExpandedAsJoinRHS() {
        String MAP_NAME_2 = "map2";
        IMap map2 = SqlExpandViewTest.instance().getMap("map2");
        SqlExpandViewTest.createMapping("map2", Integer.class, Integer.class);
        map2.put((Object)1, (Object)1);
        String sql = "CREATE VIEW v AS SELECT * FROM map";
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM map2 JOIN v ON v.__key = map2.__key", Collections.singletonList(new SqlTestSupport.Row(1, 1, 1, 1)));
    }

    @Test
    public void when_viewIsExpandedWithOrdering() {
        this.map.put((Object)2, (Object)2);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map ORDER BY __key DESC", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT * FROM map ORDER BY __key", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Arrays.asList(new SqlTestSupport.Row(2, 2), new SqlTestSupport.Row(1, 1)));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void when_viewIsExpandedWithUnionAll() {
        String MAP_NAME_2 = "map2";
        IMap map2 = SqlExpandViewTest.instance().getMap("map2");
        SqlExpandViewTest.createMapping("map2", Integer.class, Integer.class);
        map2.put((Object)2, (Object)2);
        String sql = "CREATE VIEW v AS (SELECT * FROM map UNION ALL SELECT * FROM map2)";
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS (SELECT * FROM map UNION ALL SELECT * FROM map2)", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void when_viewIsExpandedWithValues() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM ( VALUES(1, 1), (2, 2) )", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Arrays.asList(new SqlTestSupport.Row((byte)1, (byte)1), new SqlTestSupport.Row((byte)2, (byte)2)));
    }

    @Ignore(value="SCALAR QUERY not supported")
    @Test
    public void when_viewIsExpandedWithValuesAndSubQueryWithin() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT 2", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vvv AS SELECT * FROM ( VALUES(SELECT * FROM v), (SELECT * FROM vv) )", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT (SELECT 1 FROM v limit 1) FROM map", Collections.singletonList(new SqlTestSupport.Row((byte)1)));
    }

    @Test
    public void when_viewIsExpandedWithAggFunction() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT MAX(__key) FROM map", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.singletonList(new SqlTestSupport.Row(1)));
    }

    @Test
    public void when_viewIsExpandedWithTumbleFunction() {
        String name = SqlExpandViewTest.createStreamingTable(SqlExpandViewTest.instance().getSql(), SqlExpandViewTest.row(SqlExpandViewTest.timestampTz(0L), "Alice", 1), SqlExpandViewTest.row(SqlExpandViewTest.timestampTz(1L), null, null), SqlExpandViewTest.row(SqlExpandViewTest.timestampTz(2L), "Alice", 1), SqlExpandViewTest.row(SqlExpandViewTest.timestampTz(3L), "Bob", 1), SqlExpandViewTest.row(SqlExpandViewTest.timestampTz(10L), null, null));
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND))", new Object[0]);
        SqlExpandViewTest.assertRowsEventuallyInAnyOrder("SELECT window_start, SUM(distance) FROM TABLE(TUMBLE(TABLE v, DESCRIPTOR(ts), INTERVAL '0.002' SECOND)) GROUP BY window_start", Arrays.asList(new SqlTestSupport.Row(SqlExpandViewTest.timestampTz(0L), 1L), new SqlTestSupport.Row(SqlExpandViewTest.timestampTz(2L), 2L)));
    }

    @Test
    public void when_viewIsExpandedWithGroupByAndHaving() {
        this.map.put((Object)2, (Object)2);
        this.map.put((Object)3, (Object)3);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT this FROM map GROUP BY (this) HAVING AVG(this) = 2", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v", Collections.singletonList(new SqlTestSupport.Row(2)));
    }

    @Test
    public void when_viewIsExpandedWithJsonFunctions() {
        SqlExpandViewTest.createMapping("test", "bigint", "json");
        SqlExpandViewTest.instance().getSql().execute("INSERT INTO test VALUES (1, '[1,2,3]')", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("INSERT INTO test VALUES (2, '[4,5,6]')", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v1 AS SELECT JSON_VALUE(this, '$[1]' RETURNING BIGINT NULL ON EMPTY NULL ON ERROR) FROM test", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v2 AS SELECT JSON_QUERY(this, '$[1]' WITH CONDITIONAL WRAPPER EMPTY OBJECT ON EMPTY EMPTY OBJECT ON ERROR) FROM test", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v1", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(5L)));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM v2", Arrays.asList(new SqlTestSupport.Row(new HazelcastJsonValue("2")), new SqlTestSupport.Row(new HazelcastJsonValue("5"))));
    }

    @Test
    public void when_doubleViewIsExpandedDuringQuery() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE __key = 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT * FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void when_doubleViewIsExpandedDuringQueryWithProjection() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE __key = 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT __key FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv", Collections.singletonList(new SqlTestSupport.Row(1)));
    }

    @Test
    public void when_doubleViewIsExpandedDuringQueryWithStringConcat() {
        IMap map2 = SqlExpandViewTest.instance().getMap("map2");
        SqlExpandViewTest.createMapping("map2", String.class, String.class);
        map2.put((Object)"a", (Object)"b");
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map2", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT __key || this FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv", Collections.singletonList(new SqlTestSupport.Row("ab")));
    }

    @Test
    public void when_doubleViewIsExpandedDuringQueryWithFunctionProjections() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE this = 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT MAX(this) FROM v", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vvv AS SELECT COUNT(this) FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv", SqlExpandViewTest.rows(1, 1));
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vvv", SqlExpandViewTest.rows(1, 1L));
    }

    @Test
    public void when_tripleViewIsExpandedDuringQuery() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE __key = 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT * FROM v", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vvv AS SELECT * FROM vv", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vvv", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void when_doubleViewWithQueryFilter() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM map WHERE __key > 0", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT * FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv WHERE __key = 1", Collections.singletonList(new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void when_doubleViewExpandedAndProjectedInNestedQuery() {
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM (SELECT __key FROM map) WHERE __key = 1", new Object[0]);
        SqlExpandViewTest.instance().getSql().execute("CREATE VIEW vv AS SELECT * FROM v", new Object[0]);
        SqlExpandViewTest.assertRowsAnyOrder("SELECT * FROM vv WHERE __key = 1", Collections.singletonList(new SqlTestSupport.Row(1)));
    }

    private static String createStreamingTable(SqlService service, Object[] ... values) {
        String name = SqlExpandViewTest.randomName();
        TestStreamSqlConnector.create(service, name, Arrays.asList("ts", "name", "distance"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), values);
        return name;
    }
}

