/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlBasicTest
extends SqlTestSupport {
    private static final int IDS_FACTORY_ID = 1;
    private static final int IDS_KEY_CLASS_ID = 2;
    private static final int IDS_VALUE_CLASS_ID = 3;
    static final int PORTABLE_FACTORY_ID = 1;
    static final int PORTABLE_KEY_CLASS_ID = 2;
    static final int PORTABLE_VALUE_CLASS_ID = 3;
    private static final int PORTABLE_NESTED_CLASS_ID = 4;
    private static final String MAP_OBJECT = "map_object";
    private static final String MAP_BINARY = "map_binary";
    protected static final int PAGE_SIZE = 256;
    protected static final int DATA_SET_SIZE = 4096;
    protected static HazelcastInstance member1;
    protected static HazelcastInstance member2;
    protected static HazelcastInstance client;
    @Parameterized.Parameter
    public int cursorBufferSize;
    @Parameterized.Parameter(value=1)
    public int dataSetSize;
    @Parameterized.Parameter(value=2)
    public SerializationMode serializationMode;
    @Parameterized.Parameter(value=3)
    public InMemoryFormat inMemoryFormat;

    @Parameterized.Parameters(name="cursorBufferSize:{0}, dataSetSize:{1}, serializationMode:{2}, inMemoryFormat:{3}")
    public static Collection<Object[]> parameters() {
        return Collections.singletonList(new Object[]{256, 4096, SerializationMode.SERIALIZABLE, InMemoryFormat.BINARY});
    }

    @BeforeClass
    public static void beforeClass() {
        SqlBasicTest.initializeWithClientAndConfigSupplier((int)2, SqlBasicTest::memberConfig, (ClientConfig)SqlBasicTest.clientConfig());
        member1 = SqlBasicTest.instances()[0];
        member2 = SqlBasicTest.instances()[1];
        client = SqlBasicTest.client();
    }

    protected HazelcastInstance getTarget() {
        return member1;
    }

    @Test
    public void testSelect() {
        boolean multiPageClient;
        if (this.isPortable()) {
            SqlBasicTest.createMapping(this.mapName(), 1, 2, 0, 1, 3, 0);
        } else {
            SqlBasicTest.createMapping(this.mapName(), this.keyClass(), this.valueClass());
        }
        IMap map = this.getTarget().getMap(this.mapName());
        HashMap<AbstractPojoKey, AbstractPojo> data = new HashMap<AbstractPojoKey, AbstractPojo>();
        for (long i = 0L; i < (long)this.dataSetSize; ++i) {
            data.put(this.key(i), this.value(i));
        }
        map.putAll(data);
        Assert.assertEquals((long)this.dataSetSize, (long)map.size());
        boolean portable = this.serializationMode == SerializationMode.PORTABLE;
        try (SqlResult res = this.query();){
            multiPageClient = this.memberClientCursors() > 0;
            SqlRowMetadata rowMetadata = res.getRowMetadata();
            this.checkRowMetadata(rowMetadata);
            HashSet<Long> uniqueKeys = new HashSet<Long>();
            Iterator rowIterator = res.iterator();
            while (rowIterator.hasNext()) {
                SqlRow row = (SqlRow)rowIterator.next();
                Assert.assertEquals((Object)rowMetadata, (Object)res.getRowMetadata());
                Long key0 = (Long)row.getObject(rowMetadata.findColumn(this.adjustFieldName("key")));
                Assert.assertNotNull((Object)key0);
                AbstractPojoKey key = this.key(key0);
                AbstractPojo val = (AbstractPojo)map.get((Object)key);
                this.checkRowValue(SqlColumnType.BIGINT, key.getKey(), row, "key");
                this.checkRowValue(SqlColumnType.BOOLEAN, val.isBooleanVal(), row, "booleanVal");
                this.checkRowValue(SqlColumnType.TINYINT, val.getTinyIntVal(), row, "tinyIntVal");
                this.checkRowValue(SqlColumnType.SMALLINT, val.getSmallIntVal(), row, "smallIntVal");
                this.checkRowValue(SqlColumnType.INTEGER, val.getIntVal(), row, "intVal");
                this.checkRowValue(SqlColumnType.BIGINT, val.getBigIntVal(), row, "bigIntVal");
                this.checkRowValue(SqlColumnType.REAL, Float.valueOf(val.getRealVal()), row, "realVal");
                this.checkRowValue(SqlColumnType.DOUBLE, val.getDoubleVal(), row, "doubleVal");
                if (!portable) {
                    this.checkRowValue(SqlColumnType.DECIMAL, new BigDecimal(val.getDecimalBigIntegerVal()), row, "decimalBigIntegerVal");
                }
                this.checkRowValue(SqlColumnType.DECIMAL, val.getDecimalVal(), row, "decimalVal");
                this.checkRowValue(SqlColumnType.VARCHAR, Character.toString(val.getCharVal()), row, "charVal");
                this.checkRowValue(SqlColumnType.VARCHAR, val.getVarcharVal(), row, "varcharVal");
                this.checkRowValue(SqlColumnType.DATE, val.getDateVal(), row, "dateVal");
                this.checkRowValue(SqlColumnType.TIME, val.getTimeVal(), row, "timeVal");
                this.checkRowValue(SqlColumnType.TIMESTAMP, val.getTimestampVal(), row, "timestampVal");
                if (portable) {
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, val.getTsTzOffsetDateTimeVal(), row, "tsTzOffsetDateTimeVal");
                    this.checkRowValue(SqlColumnType.OBJECT, ((PortablePojo)val).getPortableVal(), row, "portableVal");
                    this.checkRowValue(SqlColumnType.VARCHAR, null, row, "nullVal");
                } else {
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.ofInstant(val.getTsTzDateVal().toInstant(), ZoneId.systemDefault()), row, "tsTzDateVal");
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, val.getTsTzCalendarVal().toZonedDateTime().toOffsetDateTime(), row, "tsTzCalendarVal");
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.ofInstant(val.getTsTzInstantVal(), ZoneId.systemDefault()), row, "tsTzInstantVal");
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, val.getTsTzOffsetDateTimeVal(), row, "tsTzOffsetDateTimeVal");
                    this.checkRowValue(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, val.getTsTzZonedDateTimeVal().toOffsetDateTime(), row, "tsTzZonedDateTimeVal");
                    this.checkRowValue(SqlColumnType.OBJECT, val.getObjectVal(), row, "objectVal");
                    this.checkRowValue(SqlColumnType.OBJECT, null, row, "nullVal");
                }
                uniqueKeys.add(key0);
                SqlBasicTest.assertThrows(IndexOutOfBoundsException.class, () -> row.getObject(-1));
                SqlBasicTest.assertThrows(IndexOutOfBoundsException.class, () -> row.getObject(row.getMetadata().getColumnCount()));
                SqlBasicTest.assertThrows(NullPointerException.class, () -> row.getObject(null));
                SqlBasicTest.assertThrows(IllegalArgumentException.class, () -> row.getObject("unknown_field"));
            }
            SqlBasicTest.assertThrows(NoSuchElementException.class, rowIterator::next);
            SqlBasicTest.assertThrows(IllegalStateException.class, () -> ((SqlResult)res).iterator());
            Assert.assertEquals((long)this.dataSetSize, (long)uniqueKeys.size());
        }
        if (multiPageClient) {
            Assert.assertEquals((long)0L, (long)this.memberClientCursors());
            res = this.query();
            try {
                Assert.assertEquals((long)1L, (long)this.memberClientCursors());
                res.close();
                Assert.assertEquals((long)0L, (long)this.memberClientCursors());
            }
            finally {
                if (res != null) {
                    res.close();
                }
            }
        }
    }

    private int memberClientCursors() {
        return SqlBasicTest.sqlInternalService(member1).getClientStateRegistry().getCursorCount() + SqlBasicTest.sqlInternalService(member2).getClientStateRegistry().getCursorCount();
    }

    private void checkRowValue(SqlColumnType expectedType, Object expectedValue, SqlRow row, String columnName) {
        columnName = this.adjustFieldName(columnName);
        int columnIndex = row.getMetadata().findColumn(columnName);
        Assert.assertNotEquals((long)-1L, (long)columnIndex);
        Assert.assertEquals((Object)expectedType, (Object)row.getMetadata().getColumn(columnIndex).getType());
        Object valueByIndex = row.getObject(columnIndex);
        Assert.assertEquals((Object)expectedValue, (Object)valueByIndex);
        Object valueByName = row.getObject(columnIndex);
        Assert.assertEquals((Object)expectedValue, (Object)valueByName);
    }

    private void checkRowMetadata(SqlRowMetadata rowMetadata) {
        List<String> fields = this.fields();
        List<SqlColumnType> fieldTypes = this.fieldTypes();
        Assert.assertEquals((long)fields.size(), (long)rowMetadata.getColumnCount());
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String adjustedField = this.adjustFieldName(field);
            SqlColumnType fieldType = fieldTypes.get(i);
            int fieldIndex = rowMetadata.findColumn(adjustedField);
            Assert.assertNotEquals((long)-1L, (long)fieldIndex);
            SqlColumnMetadata columnMetadata = rowMetadata.getColumn(fieldIndex);
            Assert.assertEquals((Object)adjustedField, (Object)columnMetadata.getName());
            Assert.assertEquals((Object)fieldType, (Object)columnMetadata.getType());
            Assert.assertTrue((boolean)columnMetadata.isNullable());
        }
        SqlBasicTest.assertThrows(IndexOutOfBoundsException.class, () -> rowMetadata.getColumn(-1));
        SqlBasicTest.assertThrows(IndexOutOfBoundsException.class, () -> rowMetadata.getColumn(fields.size()));
    }

    private SqlResult query() {
        String sql = this.sql();
        if (this.cursorBufferSize == 4096) {
            return this.getTarget().getSql().execute(sql, new Object[0]);
        }
        return this.getTarget().getSql().execute(new SqlStatement(sql).setCursorBufferSize(this.cursorBufferSize));
    }

    private List<String> fields() {
        if (this.serializationMode == SerializationMode.PORTABLE) {
            return Arrays.asList("key", "booleanVal", "tinyIntVal", "smallIntVal", "intVal", "bigIntVal", "realVal", "doubleVal", "decimalVal", "charVal", "varcharVal", "dateVal", "timeVal", "timestampVal", "tsTzOffsetDateTimeVal", "portableVal", "nullVal");
        }
        return Arrays.asList("key", "booleanVal", "tinyIntVal", "smallIntVal", "intVal", "bigIntVal", "realVal", "doubleVal", "decimalBigIntegerVal", "decimalVal", "charVal", "varcharVal", "dateVal", "timeVal", "timestampVal", "tsTzDateVal", "tsTzCalendarVal", "tsTzInstantVal", "tsTzOffsetDateTimeVal", "tsTzZonedDateTimeVal", "objectVal", "nullVal");
    }

    private List<SqlColumnType> fieldTypes() {
        if (this.serializationMode == SerializationMode.PORTABLE) {
            return Arrays.asList(SqlColumnType.BIGINT, SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, SqlColumnType.SMALLINT, SqlColumnType.INTEGER, SqlColumnType.BIGINT, SqlColumnType.REAL, SqlColumnType.DOUBLE, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR, SqlColumnType.VARCHAR, SqlColumnType.DATE, SqlColumnType.TIME, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.OBJECT, SqlColumnType.VARCHAR);
        }
        return Arrays.asList(SqlColumnType.BIGINT, SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, SqlColumnType.SMALLINT, SqlColumnType.INTEGER, SqlColumnType.BIGINT, SqlColumnType.REAL, SqlColumnType.DOUBLE, SqlColumnType.DECIMAL, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR, SqlColumnType.VARCHAR, SqlColumnType.DATE, SqlColumnType.TIME, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.OBJECT, SqlColumnType.OBJECT);
    }

    private String sql() {
        List<String> fields = this.fields();
        StringBuilder res = new StringBuilder("SELECT ");
        for (int i = 0; i < fields.size(); ++i) {
            String field = this.adjustFieldName(fields.get(i));
            if (i != 0) {
                res.append(", ");
            }
            res.append(field);
        }
        res.append(" FROM ").append(this.mapName());
        return res.toString();
    }

    private boolean isPortable() {
        return this.serializationMode == SerializationMode.PORTABLE;
    }

    protected String mapName() {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? MAP_OBJECT : MAP_BINARY;
    }

    private AbstractPojoKey key(long i) {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return new SerializablePojoKey(i);
            }
            case DATA_SERIALIZABLE: {
                return new DataSerializablePojoKey(i);
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return new IdentifiedDataSerializablePojoKey(i);
            }
        }
        return new PortablePojoKey(i);
    }

    private Class<?> keyClass() {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return SerializablePojoKey.class;
            }
            case DATA_SERIALIZABLE: {
                return DataSerializablePojoKey.class;
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return IdentifiedDataSerializablePojoKey.class;
            }
        }
        return PortablePojoKey.class;
    }

    private AbstractPojo value(long i) {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return new SerializablePojo(i);
            }
            case DATA_SERIALIZABLE: {
                return new DataSerializablePojo(i);
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return new IdentifiedDataSerializablePojo(i);
            }
        }
        return new PortablePojo(i);
    }

    private Class<?> valueClass() {
        switch (this.serializationMode) {
            case SERIALIZABLE: {
                return SerializablePojo.class;
            }
            case DATA_SERIALIZABLE: {
                return DataSerializablePojo.class;
            }
            case IDENTIFIED_DATA_SERIALIZABLE: {
                return IdentifiedDataSerializablePojo.class;
            }
        }
        return PortablePojo.class;
    }

    public static SerializationConfig serializationConfig() {
        SerializationConfig serializationConfig = new SerializationConfig();
        ClassDefinition nestedClassDefinition = new ClassDefinitionBuilder(1, 4, 0).addIntField("val").build();
        ClassDefinition valueClassDefinition = new ClassDefinitionBuilder(1, 3, 0).addBooleanField(SqlBasicTest.portableFieldName("booleanVal")).addByteField(SqlBasicTest.portableFieldName("tinyIntVal")).addShortField(SqlBasicTest.portableFieldName("smallIntVal")).addIntField(SqlBasicTest.portableFieldName("intVal")).addLongField(SqlBasicTest.portableFieldName("bigIntVal")).addFloatField(SqlBasicTest.portableFieldName("realVal")).addDoubleField(SqlBasicTest.portableFieldName("doubleVal")).addDecimalField(SqlBasicTest.portableFieldName("decimalVal")).addCharField(SqlBasicTest.portableFieldName("charVal")).addStringField(SqlBasicTest.portableFieldName("varcharVal")).addDateField(SqlBasicTest.portableFieldName("dateVal")).addTimeField(SqlBasicTest.portableFieldName("timeVal")).addTimestampField(SqlBasicTest.portableFieldName("timestampVal")).addTimestampWithTimezoneField(SqlBasicTest.portableFieldName("tsTzOffsetDateTimeVal")).addPortableField(SqlBasicTest.portableFieldName("portableVal"), nestedClassDefinition).addStringField(SqlBasicTest.portableFieldName("nullVal")).build();
        ClassDefinition keyClassDefinition = new ClassDefinitionBuilder(1, 2, 0).addLongField(SqlBasicTest.portableFieldName("key")).build();
        serializationConfig.addClassDefinition(nestedClassDefinition);
        serializationConfig.addClassDefinition(valueClassDefinition);
        serializationConfig.addClassDefinition(keyClassDefinition);
        serializationConfig.addPortableFactory(1, classId -> {
            if (classId == 2) {
                return new PortablePojoKey();
            }
            if (classId == 3) {
                return new PortablePojo();
            }
            if (classId == 4) {
                return new PortablePojoNested();
            }
            throw new IllegalArgumentException("Unsupported class ID: " + classId);
        });
        serializationConfig.addDataSerializableFactory(1, classId -> {
            if (classId == 2) {
                return new IdentifiedDataSerializablePojoKey();
            }
            if (classId == 3) {
                return new IdentifiedDataSerializablePojo();
            }
            throw new IllegalArgumentException("Unsupported class ID: " + classId);
        });
        return serializationConfig;
    }

    static Config memberConfig() {
        return SqlBasicTest.smallInstanceConfig().addMapConfig(new MapConfig(MAP_OBJECT).setInMemoryFormat(InMemoryFormat.OBJECT)).addMapConfig(new MapConfig(MAP_BINARY).setInMemoryFormat(InMemoryFormat.BINARY)).setSerializationConfig(SqlBasicTest.serializationConfig());
    }

    protected static ClientConfig clientConfig() {
        return new ClientConfig().setSerializationConfig(SqlBasicTest.serializationConfig());
    }

    private String adjustFieldName(String fieldName) {
        if (this.isPortable()) {
            fieldName = SqlBasicTest.portableFieldName(fieldName);
        }
        return fieldName;
    }

    static String portableFieldName(String fieldName) {
        return fieldName + "_p";
    }

    public static enum SerializationMode {
        SERIALIZABLE,
        DATA_SERIALIZABLE,
        IDENTIFIED_DATA_SERIALIZABLE,
        PORTABLE;

    }

    static abstract class AbstractPojoKey
    implements Serializable {
        protected long key;

        protected AbstractPojoKey() {
        }

        protected AbstractPojoKey(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        public String toString() {
            return "AbstractPojoKey{key=" + this.key + "}";
        }
    }

    static abstract class AbstractPojo
    implements Serializable {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
        protected boolean booleanVal;
        protected byte tinyIntVal;
        protected short smallIntVal;
        protected int intVal;
        protected long bigIntVal;
        protected float realVal;
        protected double doubleVal;
        protected BigInteger decimalBigIntegerVal;
        protected BigDecimal decimalVal;
        protected char charVal;
        protected String varcharVal;
        protected LocalTime timeVal;
        protected LocalDate dateVal;
        protected LocalDateTime timestampVal;
        protected Date tsTzDateVal;
        protected GregorianCalendar tsTzCalendarVal;
        protected Instant tsTzInstantVal;
        protected OffsetDateTime tsTzOffsetDateTimeVal;
        protected ZonedDateTime tsTzZonedDateTimeVal;
        protected List<Object> objectVal;
        protected Object nullVal;

        protected AbstractPojo() {
        }

        protected AbstractPojo(long val) {
            this.booleanVal = val % 2L == 0L;
            this.tinyIntVal = (byte)val;
            this.smallIntVal = (short)val;
            this.intVal = (int)val;
            this.bigIntVal = val;
            this.realVal = val;
            this.doubleVal = val;
            this.decimalBigIntegerVal = BigInteger.valueOf(val);
            this.decimalVal = BigDecimal.valueOf(val);
            this.charVal = (char)99;
            this.varcharVal = Long.toString(val);
            this.timestampVal = LocalDateTime.now();
            this.dateVal = this.timestampVal.toLocalDate();
            this.timeVal = this.timestampVal.toLocalTime();
            this.tsTzDateVal = new Date();
            this.tsTzCalendarVal = (GregorianCalendar)GregorianCalendar.getInstance(UTC);
            this.tsTzInstantVal = Instant.now();
            this.tsTzOffsetDateTimeVal = OffsetDateTime.now();
            this.tsTzZonedDateTimeVal = ZonedDateTime.now();
            this.objectVal = new ArrayList<Object>(1);
            this.objectVal.add(val);
        }

        public boolean isBooleanVal() {
            return this.booleanVal;
        }

        public byte getTinyIntVal() {
            return this.tinyIntVal;
        }

        public short getSmallIntVal() {
            return this.smallIntVal;
        }

        public int getIntVal() {
            return this.intVal;
        }

        public long getBigIntVal() {
            return this.bigIntVal;
        }

        public float getRealVal() {
            return this.realVal;
        }

        public double getDoubleVal() {
            return this.doubleVal;
        }

        public BigInteger getDecimalBigIntegerVal() {
            return this.decimalBigIntegerVal;
        }

        public BigDecimal getDecimalVal() {
            return this.decimalVal;
        }

        public char getCharVal() {
            return this.charVal;
        }

        public String getVarcharVal() {
            return this.varcharVal;
        }

        public LocalTime getTimeVal() {
            return this.timeVal;
        }

        public LocalDate getDateVal() {
            return this.dateVal;
        }

        public LocalDateTime getTimestampVal() {
            return this.timestampVal;
        }

        public Date getTsTzDateVal() {
            return this.tsTzDateVal;
        }

        public GregorianCalendar getTsTzCalendarVal() {
            return this.tsTzCalendarVal;
        }

        public Instant getTsTzInstantVal() {
            return this.tsTzInstantVal;
        }

        public OffsetDateTime getTsTzOffsetDateTimeVal() {
            return this.tsTzOffsetDateTimeVal;
        }

        public ZonedDateTime getTsTzZonedDateTimeVal() {
            return this.tsTzZonedDateTimeVal;
        }

        public List<Object> getObjectVal() {
            return this.objectVal;
        }

        public Object getNullVal() {
            return this.nullVal;
        }
    }

    static class PortablePojo
    extends AbstractPojo
    implements Portable {
        private PortablePojoNested portableVal;

        public PortablePojo() {
        }

        public PortablePojo(long val) {
            super(val);
            this.portableVal = new PortablePojoNested((int)val);
        }

        public PortablePojoNested getPortableVal() {
            return this.portableVal;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 3;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeBoolean(SqlBasicTest.portableFieldName("booleanVal"), this.booleanVal);
            writer.writeByte(SqlBasicTest.portableFieldName("tinyIntVal"), this.tinyIntVal);
            writer.writeShort(SqlBasicTest.portableFieldName("smallIntVal"), this.smallIntVal);
            writer.writeInt(SqlBasicTest.portableFieldName("intVal"), this.intVal);
            writer.writeLong(SqlBasicTest.portableFieldName("bigIntVal"), this.bigIntVal);
            writer.writeFloat(SqlBasicTest.portableFieldName("realVal"), this.realVal);
            writer.writeDouble(SqlBasicTest.portableFieldName("doubleVal"), this.doubleVal);
            writer.writeDecimal(SqlBasicTest.portableFieldName("decimalVal"), this.decimalVal);
            writer.writeChar(SqlBasicTest.portableFieldName("charVal"), (int)this.charVal);
            writer.writeString(SqlBasicTest.portableFieldName("varcharVal"), this.varcharVal);
            writer.writeDate(SqlBasicTest.portableFieldName("dateVal"), this.dateVal);
            writer.writeTime(SqlBasicTest.portableFieldName("timeVal"), this.timeVal);
            writer.writeTimestamp(SqlBasicTest.portableFieldName("timestampVal"), this.timestampVal);
            writer.writeTimestampWithTimezone(SqlBasicTest.portableFieldName("tsTzOffsetDateTimeVal"), this.tsTzOffsetDateTimeVal);
            writer.writePortable(SqlBasicTest.portableFieldName("portableVal"), (Portable)this.portableVal);
            writer.writeString(SqlBasicTest.portableFieldName("nullVal"), null);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.booleanVal = reader.readBoolean(SqlBasicTest.portableFieldName("booleanVal"));
            this.tinyIntVal = reader.readByte(SqlBasicTest.portableFieldName("tinyIntVal"));
            this.smallIntVal = reader.readShort(SqlBasicTest.portableFieldName("smallIntVal"));
            this.intVal = reader.readInt(SqlBasicTest.portableFieldName("intVal"));
            this.bigIntVal = reader.readLong(SqlBasicTest.portableFieldName("bigIntVal"));
            this.realVal = reader.readFloat(SqlBasicTest.portableFieldName("realVal"));
            this.doubleVal = reader.readDouble(SqlBasicTest.portableFieldName("doubleVal"));
            this.decimalVal = reader.readDecimal(SqlBasicTest.portableFieldName("decimalVal"));
            this.charVal = reader.readChar(SqlBasicTest.portableFieldName("charVal"));
            this.varcharVal = reader.readString(SqlBasicTest.portableFieldName("varcharVal"));
            this.dateVal = reader.readDate(SqlBasicTest.portableFieldName("dateVal"));
            this.timeVal = reader.readTime(SqlBasicTest.portableFieldName("timeVal"));
            this.timestampVal = reader.readTimestamp(SqlBasicTest.portableFieldName("timestampVal"));
            this.tsTzOffsetDateTimeVal = reader.readTimestampWithTimezone(SqlBasicTest.portableFieldName("tsTzOffsetDateTimeVal"));
            this.portableVal = (PortablePojoNested)reader.readPortable(SqlBasicTest.portableFieldName("portableVal"));
            this.nullVal = reader.readString(SqlBasicTest.portableFieldName("nullVal"));
        }
    }

    static class PortablePojoNested
    implements Portable {
        private int val;

        public PortablePojoNested() {
        }

        public PortablePojoNested(int val) {
            this.val = val;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 4;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("val", this.val);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.val = reader.readInt("val");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortablePojoNested that = (PortablePojoNested)o;
            return this.val == that.val;
        }

        public int hashCode() {
            return this.val;
        }
    }

    public static class SerializablePojoKey
    extends AbstractPojoKey
    implements Serializable {
        public SerializablePojoKey(long key) {
            super(key);
        }
    }

    static class DataSerializablePojoKey
    extends AbstractPojoKey
    implements DataSerializable {
        public DataSerializablePojoKey() {
        }

        public DataSerializablePojoKey(long key) {
            super(key);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.key);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.key = in.readLong();
        }
    }

    static class IdentifiedDataSerializablePojoKey
    extends DataSerializablePojoKey
    implements IdentifiedDataSerializable {
        public IdentifiedDataSerializablePojoKey() {
        }

        public IdentifiedDataSerializablePojoKey(long key) {
            super(key);
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }
    }

    static class PortablePojoKey
    extends AbstractPojoKey
    implements Portable {
        public PortablePojoKey() {
        }

        public PortablePojoKey(long key) {
            super(key);
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeLong(SqlBasicTest.portableFieldName("key"), this.key);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.key = reader.readLong(SqlBasicTest.portableFieldName("key"));
        }
    }

    static class SerializablePojo
    extends AbstractPojo
    implements Serializable {
        public SerializablePojo() {
        }

        public SerializablePojo(long val) {
            super(val);
        }
    }

    static class DataSerializablePojo
    extends AbstractPojo
    implements DataSerializable {
        public DataSerializablePojo() {
        }

        public DataSerializablePojo(long val) {
            super(val);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeBoolean(this.booleanVal);
            out.writeByte((int)this.tinyIntVal);
            out.writeShort((int)this.smallIntVal);
            out.writeInt(this.intVal);
            out.writeLong(this.bigIntVal);
            out.writeFloat(this.realVal);
            out.writeDouble(this.doubleVal);
            out.writeObject((Object)this.decimalBigIntegerVal);
            out.writeObject((Object)this.decimalVal);
            out.writeChar((int)this.charVal);
            out.writeString(this.varcharVal);
            out.writeObject((Object)this.dateVal);
            out.writeObject((Object)this.timeVal);
            out.writeObject((Object)this.timestampVal);
            out.writeObject((Object)this.tsTzDateVal);
            out.writeObject((Object)this.tsTzCalendarVal);
            out.writeObject((Object)this.tsTzInstantVal);
            out.writeObject((Object)this.tsTzOffsetDateTimeVal);
            out.writeObject((Object)this.tsTzZonedDateTimeVal);
            out.writeObject((Object)this.objectVal);
            out.writeObject(this.nullVal);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.booleanVal = in.readBoolean();
            this.tinyIntVal = in.readByte();
            this.smallIntVal = in.readShort();
            this.intVal = in.readInt();
            this.bigIntVal = in.readLong();
            this.realVal = in.readFloat();
            this.doubleVal = in.readDouble();
            this.decimalBigIntegerVal = (BigInteger)in.readObject();
            this.decimalVal = (BigDecimal)in.readObject();
            this.charVal = in.readChar();
            this.varcharVal = in.readString();
            this.dateVal = (LocalDate)in.readObject();
            this.timeVal = (LocalTime)in.readObject();
            this.timestampVal = (LocalDateTime)in.readObject();
            this.tsTzDateVal = (Date)in.readObject();
            this.tsTzCalendarVal = (GregorianCalendar)in.readObject();
            this.tsTzInstantVal = (Instant)in.readObject();
            this.tsTzOffsetDateTimeVal = (OffsetDateTime)in.readObject();
            this.tsTzZonedDateTimeVal = (ZonedDateTime)in.readObject();
            this.objectVal = (List)in.readObject();
            this.nullVal = in.readObject();
        }
    }

    static class IdentifiedDataSerializablePojo
    extends DataSerializablePojo
    implements IdentifiedDataSerializable {
        public IdentifiedDataSerializablePojo() {
        }

        public IdentifiedDataSerializablePojo(long val) {
            super(val);
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 3;
        }
    }
}

