/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.ResultLimitReachedException;
import com.hazelcast.test.ExceptionRecorder;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class LogExceptionSqlTest
extends SimpleTestInClusterSupport {
    private static ExceptionRecorder recorder;

    @BeforeClass
    public static void setUpClass() {
        Config config = LogExceptionSqlTest.smallInstanceConfig();
        LogExceptionSqlTest.initialize((int)2, (Config)config);
        recorder = new ExceptionRecorder(LogExceptionSqlTest.instances(), Level.INFO);
    }

    @Before
    public void setUp() throws Exception {
        recorder.clear();
    }

    @Test
    public void when_limitInQueryReached_then_noExceptionIsThrown() {
        SqlService sql = LogExceptionSqlTest.instance().getSql();
        try (SqlResult result = sql.execute("select * from table(generate_stream(5)) limit 2", new Object[0]);){
            Iterator rows = result.iterator();
            while (rows.hasNext()) {
                rows.next();
            }
        }
        LogExceptionSqlTest.assertNoLightJobsLeftEventually((HazelcastInstance)LogExceptionSqlTest.instance());
        List exceptions = recorder.exceptionsOfTypes(new Class[]{ResultLimitReachedException.class, JetException.class});
        Assertions.assertThat((List)exceptions).isEmpty();
    }
}

