/*
 * MIT License
 *
 * Copyright (c) 2019 WANG Lingsong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.hazelcast.shaded.org.jsfr.json.provider;

import com.hazelcast.shaded.org.jsfr.json.resolver.DocumentResolver;

import java.math.BigInteger;

public interface JsonProvider<O, A, P> extends DocumentResolver<O, A> {

    O createObject();

    A createArray();

    void put(O object, String key, P value);

    void add(A array, P value);

    P primitive(boolean value);

    P primitive(int value);

    P primitive(BigInteger value);

    P primitive(double value);

    P primitive(long value);

    P primitive(String value);

    P primitiveNull();

    <T> T cast(P value, Class<T> tClass);

    boolean isPrimitiveNull(Object value);

    boolean isPrimitiveNumber(Object value);

    boolean isPrimitiveBoolean(Object value);

    boolean isPrimitiveString(Object value);
}
