package com.hazelcast.shaded.org.checkerframework.common.reflection.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.hazelcast.shaded.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import com.hazelcast.shaded.org.checkerframework.framework.qual.InvisibleQualifier;
import com.hazelcast.shaded.org.checkerframework.framework.qual.SubtypeOf;
import com.hazelcast.shaded.org.checkerframework.framework.qual.TargetLocations;
import com.hazelcast.shaded.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Represents a Class object whose run-time value is not known at compile time. Also represents
 * non-Class values.
 *
 * <p>This annotation is the default in the hierarchy.
 *
 * @checker_framework.manual #methodval-and-classval-checkers ClassVal Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface UnknownClass {}
