package com.hazelcast.shaded.org.checkerframework.checker.sqlquotes.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.hazelcast.shaded.org.checkerframework.framework.qual.DefaultFor;
import com.hazelcast.shaded.org.checkerframework.framework.qual.InvisibleQualifier;
import com.hazelcast.shaded.org.checkerframework.framework.qual.SubtypeOf;
import com.hazelcast.shaded.org.checkerframework.framework.qual.TargetLocations;
import com.hazelcast.shaded.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Represents the bottom of the SQL Quotes qualifier hierarchy.
 *
 * @checker_framework.manual #sql-quotes-checker SQL Quotes Checker
 * @checker_framework.manual #bottom-type the bottom type
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@InvisibleQualifier
@SubtypeOf({SqlEvenQuotes.class, SqlOddQuotes.class})
@DefaultFor(value = {TypeUseLocation.LOWER_BOUND})
public @interface SqlQuotesBottom {}
